/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy;

import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.TaskQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.engine.task.TaskQuery;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.RequestUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.legacy.LegacyTasksPaginateList;
import org.restlet.resource.Get;

public class TasksResource
extends SecuredResource {
    Map<String, QueryProperty> properties = new HashMap<String, QueryProperty>();

    public TasksResource() {
        this.properties.put("id", (QueryProperty)TaskQueryProperty.TASK_ID);
        this.properties.put("name", (QueryProperty)TaskQueryProperty.NAME);
        this.properties.put("description", (QueryProperty)TaskQueryProperty.DESCRIPTION);
        this.properties.put("priority", (QueryProperty)TaskQueryProperty.PRIORITY);
        this.properties.put("assignee", (QueryProperty)TaskQueryProperty.ASSIGNEE);
        this.properties.put("executionId", (QueryProperty)TaskQueryProperty.EXECUTION_ID);
        this.properties.put("processInstanceId", (QueryProperty)TaskQueryProperty.PROCESS_INSTANCE_ID);
    }

    @Get(value="json")
    public DataResponse getTasks() {
        if (!this.authenticate()) {
            return null;
        }
        String personalTaskUserId = this.getQuery().getValues("assignee");
        String ownerTaskUserId = this.getQuery().getValues("owner");
        String involvedTaskUserId = this.getQuery().getValues("involved");
        String candidateTaskUserId = this.getQuery().getValues("candidate");
        String candidateGroupId = this.getQuery().getValues("candidate-group");
        String strPriority = this.getQuery().getValues("priority");
        String strMinPriority = this.getQuery().getValues("minPriority");
        String strMaxPriority = this.getQuery().getValues("maxPriority");
        String strDueDate = this.getQuery().getValues("dueDate");
        String strMinDueDate = this.getQuery().getValues("minDueDate");
        String strMaxDueDate = this.getQuery().getValues("maxDueDate");
        TaskQuery taskQuery = ActivitiUtil.getTaskService().createTaskQuery();
        if (personalTaskUserId != null) {
            taskQuery.taskAssignee(personalTaskUserId);
        } else if (ownerTaskUserId != null) {
            taskQuery.taskOwner(ownerTaskUserId);
        } else if (involvedTaskUserId != null) {
            taskQuery.taskInvolvedUser(involvedTaskUserId);
        } else if (candidateTaskUserId != null) {
            taskQuery.taskCandidateUser(candidateTaskUserId);
        } else if (candidateGroupId != null) {
            taskQuery.taskCandidateGroup(candidateGroupId);
        } else {
            throw new ActivitiIllegalArgumentException("Tasks must be filtered with 'assignee', 'owner', 'involved', 'candidate' or 'candidate-group'");
        }
        if (strPriority != null) {
            taskQuery.taskPriority(RequestUtil.parseToInteger((String)strPriority));
        } else if (strMinPriority != null) {
            taskQuery.taskMinPriority(RequestUtil.parseToInteger((String)strMinPriority));
        } else if (strMaxPriority != null) {
            taskQuery.taskMaxPriority(RequestUtil.parseToInteger((String)strMaxPriority));
        }
        if (strDueDate != null) {
            taskQuery.dueDate(RequestUtil.parseToDate((String)strDueDate));
        } else if (strMinDueDate != null) {
            taskQuery.dueAfter(RequestUtil.parseToDate((String)strMinDueDate));
        } else if (strMaxDueDate != null) {
            taskQuery.dueBefore(RequestUtil.parseToDate((String)strMaxDueDate));
        }
        DataResponse dataResponse = new LegacyTasksPaginateList().paginateList(this.getQuery(), (Query)taskQuery, "id", this.properties);
        return dataResponse;
    }
}

