/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.TaskService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.restlet.resource.Get;

public class TasksSummaryResource
extends SecuredResource {
    @Get
    public ObjectNode getTasksSummary() {
        if (!this.authenticate()) {
            return null;
        }
        String user = this.getQuery().getValues("user");
        if (user == null) {
            throw new ActivitiIllegalArgumentException("No user provided");
        }
        TaskService ts = ActivitiUtil.getTaskService();
        GroupQuery query = ActivitiUtil.getIdentityService().createGroupQuery().groupMember(user).groupType("assignment");
        List groups = query.list();
        ObjectNode groupsJSON = new ObjectMapper().createObjectNode();
        for (Group group : groups) {
            long tasksInGroup = ts.createTaskQuery().taskCandidateGroup(group.getId()).count();
            groupsJSON.put(group.getName(), tasksInGroup);
        }
        ObjectNode summaryResponseJSON = new ObjectMapper().createObjectNode();
        ObjectNode totalAssignedJSON = new ObjectMapper().createObjectNode();
        totalAssignedJSON.put("total", ts.createTaskQuery().taskAssignee(user).count());
        summaryResponseJSON.put("assigned", (JsonNode)totalAssignedJSON);
        ObjectNode totalUnassignedJSON = new ObjectMapper().createObjectNode();
        totalUnassignedJSON.put("total", ts.createTaskQuery().taskCandidateUser(user).count());
        totalUnassignedJSON.put("groups", (JsonNode)groupsJSON);
        summaryResponseJSON.put("unassigned", (JsonNode)totalUnassignedJSON);
        return summaryResponseJSON;
    }
}

