/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.history;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.activiti.engine.history.HistoricDetail;
import org.activiti.engine.history.HistoricDetailQuery;
import org.activiti.engine.history.HistoricFormProperty;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.restlet.data.Status;
import org.restlet.resource.Get;

public class HistoricFormPropertiesResource
extends SecuredResource {
    @Get
    public ObjectNode getHistoricFormProperties() {
        if (!this.authenticate()) {
            return null;
        }
        String taskId = (String)this.getRequest().getAttributes().get("taskId");
        HistoricDetailQuery createHistoricDetailQuery = ActivitiUtil.getHistoryService().createHistoricDetailQuery();
        List list = createHistoricDetailQuery.taskId(taskId).formProperties().list();
        ObjectNode responseJSON = new ObjectMapper().createObjectNode();
        ArrayNode propertiesJSON = new ObjectMapper().createArrayNode();
        if (list != null) {
            for (HistoricDetail historicDetail : list) {
                HistoricFormProperty property = (HistoricFormProperty)historicDetail;
                ObjectNode propertyJSON = new ObjectMapper().createObjectNode();
                propertyJSON.put("id", property.getPropertyId());
                propertyJSON.put("value", property.getPropertyValue());
                propertiesJSON.add((JsonNode)propertyJSON);
            }
        }
        responseJSON.put("data", (JsonNode)propertiesJSON);
        return responseJSON;
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

