/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.identity;

import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngineInfo;
import org.activiti.engine.ProcessEngines;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.legacy.identity.LegacyLoginInfo;
import org.activiti.rest.service.api.legacy.identity.LegacyLoginResponse;
import org.restlet.data.Status;
import org.restlet.resource.Post;
import org.restlet.resource.ServerResource;

public class LegacyLoginResource
extends ServerResource {
    @Post
    public LegacyLoginResponse login(LegacyLoginInfo loginInfo) {
        String message;
        if (loginInfo == null) {
            throw new ActivitiIllegalArgumentException("No login info supplied");
        }
        if (loginInfo.getUserId() == null) {
            throw new ActivitiIllegalArgumentException("No user id supplied");
        }
        if (loginInfo.getPassword() == null) {
            throw new ActivitiIllegalArgumentException("No password supplied");
        }
        ProcessEngine pe = ActivitiUtil.getProcessEngine();
        if (pe != null) {
            if (!pe.getIdentityService().checkPassword(loginInfo.getUserId(), loginInfo.getPassword())) {
                throw new ActivitiException("Username and password does not match.");
            }
            return new LegacyLoginResponse().setSuccess(true);
        }
        ProcessEngineInfo pei = ActivitiUtil.getProcessEngineInfo();
        if (pei != null) {
            message = pei.getException();
        } else {
            message = "Can't find process engine which is needed to authenticate username and password.";
            List processEngineInfos = ProcessEngines.getProcessEngineInfos();
            if (processEngineInfos.size() > 0) {
                message = message + "\nHowever " + processEngineInfos.size() + " other process engine(s) were found: ";
            }
            for (ProcessEngineInfo processEngineInfo : processEngineInfos) {
                message = message + "Process engine '" + processEngineInfo.getName() + "' (" + processEngineInfo.getResourceUrl() + "):";
                if (processEngineInfo.getException() != null) {
                    message = message + processEngineInfo.getException();
                    continue;
                }
                message = message + "OK";
            }
        }
        throw new ActivitiException(message);
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

