/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.identity;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.identity.Picture;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.restlet.data.CacheDirective;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.InputRepresentation;
import org.restlet.resource.Get;

public class LegacyUserPictureResource
extends SecuredResource {
    @Get
    public InputRepresentation getPicture() {
        if (!this.authenticate()) {
            return null;
        }
        String userId = (String)this.getRequest().getAttributes().get("userId");
        if (userId == null) {
            throw new ActivitiIllegalArgumentException("No userId provided");
        }
        Picture picture = ActivitiUtil.getIdentityService().getUserPicture(userId);
        String contentType = picture.getMimeType();
        MediaType mediatType = MediaType.IMAGE_PNG;
        if (contentType != null) {
            if (contentType.contains(";")) {
                contentType = contentType.substring(0, contentType.indexOf(";"));
            }
            mediatType = MediaType.valueOf((String)contentType);
        }
        InputRepresentation output = new InputRepresentation(picture.getInputStream(), mediatType);
        this.getResponse().getCacheDirectives().add(CacheDirective.maxAge((int)28800));
        return output;
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

