/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.management;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.JobQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.engine.runtime.JobQuery;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.management.JobPaginateList;
import org.restlet.data.Form;
import org.restlet.resource.Get;

public class JobCollectionResource
extends SecuredResource {
    protected static Map<String, QueryProperty> properties = new HashMap<String, QueryProperty>();

    @Get(value="json")
    public DataResponse getJobs() {
        if (!this.authenticate()) {
            return null;
        }
        JobQuery query = ActivitiUtil.getManagementService().createJobQuery();
        Form form = this.getQuery();
        Set names = form.getNames();
        if (names.contains("id")) {
            query.jobId(this.getQueryParameter("id", form));
        }
        if (names.contains("processInstanceId")) {
            query.processInstanceId(this.getQueryParameter("processInstanceId", form));
        }
        if (names.contains("executionId")) {
            query.executionId(this.getQueryParameter("executionId", form));
        }
        if (names.contains("processDefinitionId")) {
            query.processDefinitionId(this.getQueryParameter("processDefinitionId", form));
        }
        if (names.contains("withRetriesLeft") && Boolean.TRUE.equals(this.getQueryParameterAsBoolean("withRetriesLeft", form))) {
            query.withRetriesLeft();
        }
        if (names.contains("executable") && Boolean.TRUE.equals(this.getQueryParameterAsBoolean("executable", form))) {
            query.executable();
        }
        if (names.contains("timersOnly")) {
            if (names.contains("messagesOnly")) {
                throw new ActivitiIllegalArgumentException("Only one of 'timersOnly' or 'messagesOnly' can be provided.");
            }
            if (Boolean.TRUE.equals(this.getQueryParameterAsBoolean("timersOnly", form))) {
                query.timers();
            }
        }
        if (names.contains("messagesOnly") && Boolean.TRUE.equals(this.getQueryParameterAsBoolean("messagesOnly", form))) {
            query.messages();
        }
        if (names.contains("dueBefore")) {
            query.duedateLowerThan(this.getQueryParameterAsDate("dueBefore", form));
        }
        if (names.contains("dueAfter")) {
            query.duedateHigherThan(this.getQueryParameterAsDate("dueAfter", form));
        }
        if (names.contains("withException") && Boolean.TRUE.equals(this.getQueryParameterAsBoolean("withException", form))) {
            query.withException();
        }
        if (names.contains("exceptionMessage")) {
            query.exceptionMessage(this.getQueryParameter("exceptionMessage", form));
        }
        if (names.contains("tenantId")) {
            query.jobTenantId(this.getQueryParameter("tenantId", form));
        }
        if (names.contains("tenantIdLike")) {
            query.jobTenantIdLike(this.getQueryParameter("tenantIdLike", form));
        }
        if (names.contains("withoutTenantId") && Boolean.TRUE.equals(this.getQueryParameterAsBoolean("withoutTenantId", form))) {
            query.jobWithoutTenantId();
        }
        return new JobPaginateList(this).paginateList(form, (Query)query, "id", properties);
    }

    static {
        properties.put("id", (QueryProperty)JobQueryProperty.JOB_ID);
        properties.put("dueDate", (QueryProperty)JobQueryProperty.DUEDATE);
        properties.put("executionId", (QueryProperty)JobQueryProperty.EXECUTION_ID);
        properties.put("processInstanceId", (QueryProperty)JobQueryProperty.PROCESS_INSTANCE_ID);
        properties.put("retries", (QueryProperty)JobQueryProperty.RETRIES);
        properties.put("tenantId", (QueryProperty)JobQueryProperty.TENANT_ID);
    }
}

