/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import java.io.InputStream;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.repository.Deployment;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.MediaType;
import org.restlet.representation.InputRepresentation;

public class BaseDeploymentResourceDataResource
extends SecuredResource {
    protected InputRepresentation getDeploymentResource(String deploymentId, String resourceId) {
        if (deploymentId == null) {
            throw new ActivitiIllegalArgumentException("No deployment id provided");
        }
        if (resourceId == null) {
            throw new ActivitiIllegalArgumentException("No resource id provided");
        }
        Deployment deployment = (Deployment)ActivitiUtil.getRepositoryService().createDeploymentQuery().deploymentId(deploymentId).singleResult();
        if (deployment == null) {
            throw new ActivitiObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.", Deployment.class);
        }
        List resourceList = ActivitiUtil.getRepositoryService().getDeploymentResourceNames(deploymentId);
        if (resourceList.contains(resourceId)) {
            InputStream resourceStream = ActivitiUtil.getRepositoryService().getResourceAsStream(deploymentId, resourceId);
            MediaType mediaType = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getMediaTypeResolver().resolveMediaType(resourceId);
            return new InputRepresentation(resourceStream, mediaType);
        }
        throw new ActivitiObjectNotFoundException("Could not find a resource with id '" + resourceId + "' in deployment '" + deploymentId + "'.", String.class);
    }
}

