/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.DeploymentQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.engine.repository.DeploymentQuery;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.repository.DeploymentResponse;
import org.activiti.rest.service.api.repository.DeploymentsPaginateList;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Status;
import org.restlet.ext.fileupload.RestletFileUpload;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;

public class DeploymentCollectionResource
extends SecuredResource {
    protected static final String DEPRECATED_API_DEPLOYMENT_SEGMENT = "deployment";
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();

    @Get(value="json")
    public DataResponse getDeployments() {
        Boolean withoutTenantId;
        if (!this.authenticate()) {
            return null;
        }
        DeploymentQuery deploymentQuery = ActivitiUtil.getRepositoryService().createDeploymentQuery();
        Form query = this.getQuery();
        Set names = query.getNames();
        if (names.contains("name")) {
            deploymentQuery.deploymentName(this.getQueryParameter("name", query));
        }
        if (names.contains("nameLike")) {
            deploymentQuery.deploymentNameLike(this.getQueryParameter("nameLike", query));
        }
        if (names.contains("category")) {
            deploymentQuery.deploymentCategory(this.getQueryParameter("category", query));
        }
        if (names.contains("categoryNotEquals")) {
            deploymentQuery.deploymentCategoryNotEquals(this.getQueryParameter("categoryNotEquals", query));
        }
        if (names.contains("tenantId")) {
            deploymentQuery.deploymentTenantId(this.getQueryParameter("tenantId", query));
        }
        if (names.contains("tenantIdLike")) {
            deploymentQuery.deploymentTenantIdLike(this.getQueryParameter("tenantIdLike", query));
        }
        if (names.contains("withoutTenantId") && Boolean.TRUE == (withoutTenantId = this.getQueryParameterAsBoolean("withoutTenantId", query))) {
            deploymentQuery.deploymentWithoutTenantId();
        }
        DataResponse response = new DeploymentsPaginateList(this).paginateList(this.getQuery(), (Query)deploymentQuery, "id", allowedSortProperties);
        return response;
    }

    @Post
    public DeploymentResponse uploadDeployment(Representation entity) {
        if (!this.authenticate()) {
            return null;
        }
        try {
            if (entity == null || entity.getMediaType() == null || !MediaType.MULTIPART_FORM_DATA.isCompatible((Metadata)entity.getMediaType())) {
                throw new ActivitiIllegalArgumentException("The request should be of type" + MediaType.MULTIPART_FORM_DATA + ".");
            }
            RestletFileUpload upload = new RestletFileUpload((FileItemFactory)new DiskFileItemFactory());
            List items = upload.parseRepresentation(entity);
            String tenantId = null;
            FileItem uploadItem = null;
            for (FileItem fileItem : items) {
                if (fileItem.isFormField()) {
                    if (!"tenantId".equals(fileItem.getFieldName())) continue;
                    tenantId = fileItem.getString("UTF-8");
                    continue;
                }
                if (fileItem.getName() == null) continue;
                uploadItem = fileItem;
            }
            if (uploadItem == null) {
                throw new ActivitiIllegalArgumentException("No file content was found in request body.");
            }
            DeploymentBuilder deploymentBuilder = ActivitiUtil.getRepositoryService().createDeployment();
            String fileName = uploadItem.getName();
            if (fileName.endsWith(".bpmn20.xml") || fileName.endsWith(".bpmn")) {
                deploymentBuilder.addInputStream(fileName, uploadItem.getInputStream());
            } else if (fileName.toLowerCase().endsWith(".bar") || fileName.toLowerCase().endsWith(".zip")) {
                deploymentBuilder.addZipInputStream(new ZipInputStream(uploadItem.getInputStream()));
            } else {
                throw new ActivitiIllegalArgumentException("File must be of type .bpmn20.xml, .bpmn, .bar or .zip");
            }
            deploymentBuilder.name(fileName);
            if (tenantId != null) {
                deploymentBuilder.tenantId(tenantId);
            }
            Deployment deployment = deploymentBuilder.deploy();
            this.setStatus(Status.SUCCESS_CREATED);
            return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createDeploymentResponse(this, deployment);
        }
        catch (Exception e) {
            if (e instanceof ActivitiException) {
                throw (ActivitiException)e;
            }
            throw new ActivitiException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        allowedSortProperties.put("id", (QueryProperty)DeploymentQueryProperty.DEPLOYMENT_ID);
        allowedSortProperties.put("name", (QueryProperty)DeploymentQueryProperty.DEPLOYMENT_NAME);
        allowedSortProperties.put("deployTime", (QueryProperty)DeploymentQueryProperty.DEPLOY_TIME);
        allowedSortProperties.put("tenantId", (QueryProperty)DeploymentQueryProperty.DEPLOYMENT_TENANT_ID);
    }
}

