/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.repository.Deployment;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.RequestUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.repository.DeploymentResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;

public class DeploymentResource
extends SecuredResource {
    @Get
    public DeploymentResponse getDeployment() {
        if (!this.authenticate()) {
            return null;
        }
        String deploymentId = this.getAttribute("deploymentId");
        if (deploymentId == null) {
            throw new ActivitiIllegalArgumentException("The deploymentId cannot be null");
        }
        Deployment deployment = (Deployment)ActivitiUtil.getRepositoryService().createDeploymentQuery().deploymentId(deploymentId).singleResult();
        if (deployment == null) {
            throw new ActivitiObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.", Deployment.class);
        }
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createDeploymentResponse(this, deployment);
    }

    @Delete
    public void deleteDeployment() {
        if (!this.authenticate()) {
            return;
        }
        String deploymentId = this.getAttribute("deploymentId");
        Boolean cascade = RequestUtil.getBoolean((Form)this.getQuery(), (String)"cascade", (boolean)false);
        if (cascade.booleanValue()) {
            ActivitiUtil.getRepositoryService().deleteDeployment(deploymentId, true);
        } else {
            ActivitiUtil.getRepositoryService().deleteDeployment(deploymentId);
        }
        this.getResponse().setStatus(Status.SUCCESS_NO_CONTENT);
    }
}

