/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.repository.Deployment;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.repository.DeploymentResourceResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.resource.Get;

public class DeploymentResourceResource
extends SecuredResource {
    @Get
    public DeploymentResourceResponse getDeploymentResource() {
        if (!this.authenticate()) {
            return null;
        }
        String deploymentId = this.getAttribute("deploymentId");
        if (deploymentId == null) {
            throw new ActivitiIllegalArgumentException("No deployment id provided");
        }
        String resourceId = this.getAttribute("resourceId");
        if (resourceId == null) {
            throw new ActivitiIllegalArgumentException("No resource id provided");
        }
        Deployment deployment = (Deployment)ActivitiUtil.getRepositoryService().createDeploymentQuery().deploymentId(deploymentId).singleResult();
        if (deployment == null) {
            throw new ActivitiObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.", Deployment.class);
        }
        List resourceList = ActivitiUtil.getRepositoryService().getDeploymentResourceNames(deploymentId);
        if (resourceList.contains(resourceId)) {
            return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createDeploymentResourceResponse(this, deploymentId, resourceId);
        }
        throw new ActivitiObjectNotFoundException("Could not find a resource with id '" + resourceId + "' in deployment '" + deploymentId + "'.", String.class);
    }
}

