/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.impl.ModelQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.repository.BaseModelResource;
import org.activiti.rest.service.api.repository.ModelRequest;
import org.activiti.rest.service.api.repository.ModelResponse;
import org.activiti.rest.service.api.repository.ModelsPaginateList;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.Post;

public class ModelCollectionResource
extends BaseModelResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();

    @Get(value="json")
    public DataResponse getModels() {
        boolean isLatestVersion;
        if (!this.authenticate()) {
            return null;
        }
        ModelQuery modelQuery = ActivitiUtil.getRepositoryService().createModelQuery();
        Form form = this.getQuery();
        Set names = form.getNames();
        if (names.contains("id")) {
            modelQuery.modelId(this.getQueryParameter("id", form));
        }
        if (names.contains("category")) {
            modelQuery.modelCategory(this.getQueryParameter("category", form));
        }
        if (names.contains("categoryLike")) {
            modelQuery.modelCategoryLike(this.getQueryParameter("categoryLike", form));
        }
        if (names.contains("categoryNotEquals")) {
            modelQuery.modelCategoryNotEquals(this.getQueryParameter("categoryNotEquals", form));
        }
        if (names.contains("name")) {
            modelQuery.modelName(this.getQueryParameter("name", form));
        }
        if (names.contains("nameLike")) {
            modelQuery.modelNameLike(this.getQueryParameter("nameLike", form));
        }
        if (names.contains("key")) {
            modelQuery.modelKey(this.getQueryParameter("key", form));
        }
        if (names.contains("version")) {
            modelQuery.modelVersion(this.getQueryParameterAsInt("version", form));
        }
        if (names.contains("latestVersion") && (isLatestVersion = this.getQueryParameterAsBoolean("latestVersion", form).booleanValue())) {
            modelQuery.latestVersion();
        }
        if (names.contains("deploymentId")) {
            modelQuery.deploymentId(this.getQueryParameter("deploymentId", form));
        }
        if (names.contains("deployed")) {
            boolean isDeployed = this.getQueryParameterAsBoolean("deployed", form);
            if (isDeployed) {
                modelQuery.deployed();
            } else {
                modelQuery.notDeployed();
            }
        }
        if (names.contains("tenantId")) {
            modelQuery.modelTenantId(this.getQueryParameter("tenantId", form));
        }
        if (names.contains("tenantIdLike")) {
            modelQuery.modelTenantIdLike(this.getQueryParameter("tenantIdLike", form));
        }
        if (names.contains("withoutTenantId") && Boolean.TRUE.equals(this.getQueryParameterAsBoolean("withoutTenantId", form))) {
            modelQuery.modelWithoutTenantId();
        }
        return new ModelsPaginateList(this).paginateList(form, (Query)modelQuery, "id", allowedSortProperties);
    }

    @Post
    public ModelResponse createModel(ModelRequest request) {
        Model model = ActivitiUtil.getRepositoryService().newModel();
        model.setCategory(request.getCategory());
        model.setDeploymentId(request.getDeploymentId());
        model.setKey(request.getKey());
        model.setMetaInfo(request.getMetaInfo());
        model.setName(request.getName());
        model.setVersion(request.getVersion());
        model.setTenantId(request.getTenantId());
        ActivitiUtil.getRepositoryService().saveModel(model);
        this.setStatus(Status.SUCCESS_CREATED);
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createModelResponse(this, model);
    }

    static {
        allowedSortProperties.put("id", (QueryProperty)ModelQueryProperty.MODEL_ID);
        allowedSortProperties.put("category", (QueryProperty)ModelQueryProperty.MODEL_CATEGORY);
        allowedSortProperties.put("createTime", (QueryProperty)ModelQueryProperty.MODEL_CREATE_TIME);
        allowedSortProperties.put("key", (QueryProperty)ModelQueryProperty.MODEL_KEY);
        allowedSortProperties.put("lastUpdateTime", (QueryProperty)ModelQueryProperty.MODEL_LAST_UPDATE_TIME);
        allowedSortProperties.put("name", (QueryProperty)ModelQueryProperty.MODEL_NAME);
        allowedSortProperties.put("version", (QueryProperty)ModelQueryProperty.MODEL_VERSION);
        allowedSortProperties.put("tenantId", (QueryProperty)ModelQueryProperty.MODEL_TENANT_ID);
    }
}

