/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import org.activiti.engine.repository.Model;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.repository.BaseModelResource;
import org.activiti.rest.service.api.repository.ModelRequest;
import org.activiti.rest.service.api.repository.ModelResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Put;

public class ModelResource
extends BaseModelResource {
    @Get
    public ModelResponse getModel() {
        if (!this.authenticate()) {
            return null;
        }
        Model model = this.getModelFromRequest();
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createModelResponse(this, model);
    }

    @Put
    public ModelResponse updateModel(ModelRequest request) {
        if (!this.authenticate()) {
            return null;
        }
        Model model = this.getModelFromRequest();
        if (request.isCategoryChanged()) {
            model.setCategory(request.getCategory());
        }
        if (request.isDeploymentChanged()) {
            model.setDeploymentId(request.getDeploymentId());
        }
        if (request.isKeyChanged()) {
            model.setKey(request.getKey());
        }
        if (request.isMetaInfoChanged()) {
            model.setMetaInfo(request.getMetaInfo());
        }
        if (request.isNameChanged()) {
            model.setName(request.getName());
        }
        if (request.isVersionChanged()) {
            model.setVersion(request.getVersion());
        }
        if (request.isTenantIdChanged()) {
            model.setTenantId(request.getTenantId());
        }
        ActivitiUtil.getRepositoryService().saveModel(model);
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createModelResponse(this, model);
    }

    @Delete
    public void deleteModel() {
        if (!this.authenticate()) {
            return;
        }
        Model model = this.getModelFromRequest();
        ActivitiUtil.getRepositoryService().deleteModel(model.getId());
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }
}

