/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.IdentityLink;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.RestIdentityLink;
import org.activiti.rest.service.api.repository.BaseProcessDefinitionResource;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.Post;

public class ProcessDefinitionIdentityLinkCollectionResource
extends BaseProcessDefinitionResource {
    @Get
    public List<RestIdentityLink> getIdentityLinks() {
        if (!this.authenticate()) {
            return null;
        }
        ArrayList<RestIdentityLink> result = new ArrayList<RestIdentityLink>();
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest();
        List identityLinks = ActivitiUtil.getRepositoryService().getIdentityLinksForProcessDefinition(processDefinition.getId());
        RestResponseFactory responseFactory = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory();
        for (IdentityLink link : identityLinks) {
            result.add(responseFactory.createRestIdentityLink(this, link));
        }
        return result;
    }

    @Post
    public RestIdentityLink createIdentityLink(RestIdentityLink identityLink) {
        if (!this.authenticate()) {
            return null;
        }
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest();
        if (identityLink.getGroup() == null && identityLink.getUser() == null) {
            throw new ActivitiIllegalArgumentException("A group or a user is required to create an identity link.");
        }
        if (identityLink.getGroup() != null && identityLink.getUser() != null) {
            throw new ActivitiIllegalArgumentException("Only one of user or group can be used to create an identity link.");
        }
        if (identityLink.getGroup() != null) {
            ActivitiUtil.getRepositoryService().addCandidateStarterGroup(processDefinition.getId(), identityLink.getGroup());
        } else {
            ActivitiUtil.getRepositoryService().addCandidateStarterUser(processDefinition.getId(), identityLink.getUser());
        }
        identityLink.setType("candidate");
        this.setStatus(Status.SUCCESS_CREATED);
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createRestIdentityLink(this, identityLink.getType(), identityLink.getUser(), identityLink.getGroup(), null, processDefinition.getId(), null);
    }
}

