/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.process.ExecutionVariableCollectionResource;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;

public class ProcessInstanceVariableCollectionResource
extends ExecutionVariableCollectionResource {
    @Override
    protected Execution getExecutionFromRequest() {
        String processInstanceId = this.getAttribute("processInstanceId");
        if (processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("The processInstanceId cannot be null");
        }
        Execution execution = (Execution)ActivitiUtil.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("Could not find a process instance with id '" + processInstanceId + "'.", ProcessInstance.class);
        }
        return execution;
    }

    @Override
    protected void addGlobalVariables(Execution execution, Map<String, RestVariable> variableMap) {
    }

    @Override
    protected void addLocalVariables(Execution execution, Map<String, RestVariable> variableMap) {
        Map rawVariables = ActivitiUtil.getRuntimeService().getVariables(execution.getId());
        List<RestVariable> globalVariables = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createRestVariables(this, rawVariables, execution.getId(), 3, RestVariable.RestVariableScope.LOCAL);
        for (RestVariable var : globalVariables) {
            if (variableMap.containsKey(var.getName())) continue;
            variableMap.put(var.getName(), var);
        }
    }

    @Override
    protected boolean allowProcessInstanceUrl() {
        return true;
    }
}

