/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.CommentRequest;
import org.activiti.rest.service.api.engine.CommentResponse;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.Post;

public class TaskCommentCollectionResource
extends TaskBaseResource {
    @Get
    public List<CommentResponse> getComments() {
        if (!this.authenticate()) {
            return null;
        }
        ArrayList<CommentResponse> result = new ArrayList<CommentResponse>();
        RestResponseFactory responseFactory = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory();
        HistoricTaskInstance task = this.getHistoricTaskFromRequest();
        for (Comment comment : ActivitiUtil.getTaskService().getTaskComments(task.getId())) {
            result.add(responseFactory.createRestComment(this, comment));
        }
        return result;
    }

    @Post
    public CommentResponse createComment(CommentRequest comment) {
        if (!this.authenticate()) {
            return null;
        }
        Task task = this.getTaskFromRequest();
        if (comment.getMessage() == null) {
            throw new ActivitiIllegalArgumentException("Comment text is required.");
        }
        TaskService taskService = ActivitiUtil.getTaskService();
        String processInstanceId = null;
        if (comment.isSaveProcessInstanceId()) {
            Task taskEntity = (Task)taskService.createTaskQuery().taskId(task.getId()).singleResult();
            processInstanceId = taskEntity.getProcessInstanceId();
        }
        Comment createdComment = taskService.addComment(task.getId(), processInstanceId, comment.getMessage());
        this.setStatus(Status.SUCCESS_CREATED);
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createRestComment(this, createdComment);
    }
}

