/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.task.Event;
import org.activiti.engine.task.Task;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.engine.EventResponse;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;

public class TaskEventResource
extends TaskBaseResource {
    @Get
    public EventResponse getEvent() {
        if (!this.authenticate()) {
            return null;
        }
        HistoricTaskInstance task = this.getHistoricTaskFromRequest();
        String eventId = this.getAttribute("eventId");
        if (eventId == null) {
            throw new ActivitiIllegalArgumentException("EventId is required.");
        }
        Event event = ActivitiUtil.getTaskService().getEvent(eventId);
        if (event == null || !task.getId().equals(event.getTaskId())) {
            throw new ActivitiObjectNotFoundException("Task '" + task.getId() + "' doesn't have an event with id '" + eventId + "'.", Event.class);
        }
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createEventResponse(this, event);
    }

    @Delete
    public void deleteEvent() {
        if (!this.authenticate()) {
            return;
        }
        Task task = this.getTaskFromRequest();
        String eventId = this.getAttribute("eventId");
        if (eventId == null) {
            throw new ActivitiIllegalArgumentException("EventId is required.");
        }
        Event event = ActivitiUtil.getTaskService().getEvent(eventId);
        if (event == null || event.getTaskId() == null || !event.getTaskId().equals(task.getId())) {
            throw new ActivitiObjectNotFoundException("Task '" + task.getId() + "' doesn't have an event with id '" + event + "'.", Event.class);
        }
        ActivitiUtil.getTaskService().deleteComment(eventId);
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }
}

