/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.RestIdentityLink;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.Post;

public class TaskIdentityLinkCollectionResource
extends TaskBaseResource {
    @Get
    public List<RestIdentityLink> getIdentityLinks() {
        if (!this.authenticate()) {
            return null;
        }
        ArrayList<RestIdentityLink> result = new ArrayList<RestIdentityLink>();
        Task task = this.getTaskFromRequest();
        List identityLinks = ActivitiUtil.getTaskService().getIdentityLinksForTask(task.getId());
        RestResponseFactory responseFactory = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory();
        for (IdentityLink link : identityLinks) {
            result.add(responseFactory.createRestIdentityLink(this, link));
        }
        return result;
    }

    @Post
    public RestIdentityLink createIdentityLink(RestIdentityLink identityLink) {
        if (!this.authenticate()) {
            return null;
        }
        Task task = this.getTaskFromRequest();
        if (identityLink.getGroup() == null && identityLink.getUser() == null) {
            throw new ActivitiIllegalArgumentException("A group or a user is required to create an identity link.");
        }
        if (identityLink.getGroup() != null && identityLink.getUser() != null) {
            throw new ActivitiIllegalArgumentException("Only one of user or group can be used to create an identity link.");
        }
        if (identityLink.getType() == null) {
            throw new ActivitiIllegalArgumentException("The identity link type is required.");
        }
        if (identityLink.getGroup() != null) {
            ActivitiUtil.getTaskService().addGroupIdentityLink(task.getId(), identityLink.getGroup(), identityLink.getType());
        } else {
            ActivitiUtil.getTaskService().addUserIdentityLink(task.getId(), identityLink.getUser(), identityLink.getType());
        }
        this.setStatus(Status.SUCCESS_CREATED);
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createRestIdentityLink(this, identityLink.getType(), identityLink.getUser(), identityLink.getGroup(), task.getId(), null, null);
    }
}

