/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.task.Task;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.IOUtils;
import org.restlet.data.Status;
import org.restlet.ext.fileupload.RestletFileUpload;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;

public class TaskVariableBaseResource
extends TaskBaseResource {
    public RestVariable getVariableFromRequest(boolean includeBinary) {
        Task task;
        String taskId = this.getAttribute("taskId");
        if (taskId == null) {
            throw new ActivitiIllegalArgumentException("The taskId cannot be null");
        }
        String variableName = this.getAttribute("variableName");
        if (variableName == null) {
            throw new ActivitiIllegalArgumentException("The variableName cannot be null");
        }
        boolean variableFound = false;
        Object value = null;
        RestVariable.RestVariableScope variableScope = RestVariable.getScopeFromString(this.getQueryParameter("scope", this.getQuery()));
        if (variableScope == null) {
            if (ActivitiUtil.getTaskService().hasVariableLocal(taskId, variableName)) {
                value = ActivitiUtil.getTaskService().getVariableLocal(taskId, variableName);
                variableScope = RestVariable.RestVariableScope.LOCAL;
                variableFound = true;
            } else {
                task = (Task)ActivitiUtil.getTaskService().createTaskQuery().taskId(taskId).singleResult();
                if (task.getExecutionId() != null && ActivitiUtil.getRuntimeService().hasVariable(task.getExecutionId(), variableName)) {
                    value = ActivitiUtil.getRuntimeService().getVariable(task.getExecutionId(), variableName);
                    variableScope = RestVariable.RestVariableScope.GLOBAL;
                    variableFound = true;
                }
            }
        } else if (variableScope == RestVariable.RestVariableScope.GLOBAL) {
            task = (Task)ActivitiUtil.getTaskService().createTaskQuery().taskId(taskId).singleResult();
            if (task.getExecutionId() != null && ActivitiUtil.getRuntimeService().hasVariable(task.getExecutionId(), variableName)) {
                value = ActivitiUtil.getRuntimeService().getVariable(task.getExecutionId(), variableName);
                variableFound = true;
            }
        } else if (variableScope == RestVariable.RestVariableScope.LOCAL && ActivitiUtil.getTaskService().hasVariableLocal(taskId, variableName)) {
            value = ActivitiUtil.getTaskService().getVariableLocal(taskId, variableName);
            variableFound = true;
        }
        if (!variableFound) {
            throw new ActivitiObjectNotFoundException("Task '" + taskId + "' doesn't have a variable with name: '" + variableName + "'.", VariableInstanceEntity.class);
        }
        RestResponseFactory responseFactory = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory();
        return responseFactory.createRestVariable(this, variableName, value, variableScope, taskId, 1, includeBinary);
    }

    protected boolean hasVariableOnScope(Task task, String variableName, RestVariable.RestVariableScope scope) {
        boolean variableFound = false;
        if (scope == RestVariable.RestVariableScope.GLOBAL) {
            if (task.getExecutionId() != null && ActivitiUtil.getRuntimeService().hasVariable(task.getExecutionId(), variableName)) {
                variableFound = true;
            }
        } else if (scope == RestVariable.RestVariableScope.LOCAL && ActivitiUtil.getTaskService().hasVariableLocal(task.getId(), variableName)) {
            variableFound = true;
        }
        return variableFound;
    }

    protected RestVariable setBinaryVariable(Representation representation, Task task, boolean isNew) {
        try {
            RestletFileUpload upload = new RestletFileUpload((FileItemFactory)new DiskFileItemFactory());
            List items = upload.parseRepresentation(representation);
            String variableScope = null;
            String variableName = null;
            String variableType = null;
            FileItem uploadItem = null;
            for (FileItem fileItem : items) {
                if (fileItem.isFormField()) {
                    if ("scope".equals(fileItem.getFieldName())) {
                        variableScope = fileItem.getString("UTF-8");
                        continue;
                    }
                    if ("name".equals(fileItem.getFieldName())) {
                        variableName = fileItem.getString("UTF-8");
                        continue;
                    }
                    if (!"type".equals(fileItem.getFieldName())) continue;
                    variableType = fileItem.getString("UTF-8");
                    continue;
                }
                if (fileItem.getName() == null) continue;
                uploadItem = fileItem;
            }
            if (uploadItem == null) {
                throw new ActivitiIllegalArgumentException("No file content was found in request body.");
            }
            if (variableName == null) {
                throw new ActivitiIllegalArgumentException("No variable name was found in request body.");
            }
            if (variableType != null) {
                if (!"binary".equals(variableType) && !"serializable".equals(variableType)) {
                    throw new ActivitiIllegalArgumentException("Only 'binary' and 'serializable' are supported as variable type.");
                }
            } else {
                variableType = "binary";
            }
            RestVariable.RestVariableScope scope = RestVariable.RestVariableScope.LOCAL;
            if (variableScope != null) {
                scope = RestVariable.getScopeFromString(variableScope);
            }
            if (variableType.equals("binary")) {
                ByteArrayOutputStream variableOutput = new ByteArrayOutputStream(Long.valueOf(uploadItem.getSize()).intValue());
                IOUtils.copy((InputStream)uploadItem.getInputStream(), (OutputStream)variableOutput);
                this.setVariable(task, variableName, variableOutput.toByteArray(), scope, isNew);
            } else {
                ObjectInputStream stream = new ObjectInputStream(uploadItem.getInputStream());
                Object value = stream.readObject();
                this.setVariable(task, variableName, value, scope, isNew);
                stream.close();
            }
            return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createBinaryRestVariable(this, variableName, scope, variableType, task.getId(), null, null);
        }
        catch (FileUploadException fue) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, (Throwable)fue);
        }
        catch (IOException ioe) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, (Throwable)ioe);
        }
        catch (ClassNotFoundException ioe) {
            throw new ResourceException(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE.getCode(), "The provided body contains a serialized object for which the class is nog found: " + ioe.getMessage(), null, null);
        }
    }

    protected RestVariable setSimpleVariable(RestVariable restVariable, Task task, boolean isNew) {
        if (restVariable.getName() == null) {
            throw new ActivitiIllegalArgumentException("Variable name is required");
        }
        RestVariable.RestVariableScope scope = restVariable.getVariableScope();
        if (scope == null) {
            scope = RestVariable.RestVariableScope.LOCAL;
        }
        Object actualVariableValue = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().getVariableValue(restVariable);
        this.setVariable(task, restVariable.getName(), actualVariableValue, scope, isNew);
        RestResponseFactory responseFactory = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory();
        return responseFactory.createRestVariable(this, restVariable.getName(), actualVariableValue, scope, task.getId(), 1, false);
    }

    protected void setVariable(Task task, String name, Object value, RestVariable.RestVariableScope scope, boolean isNew) {
        boolean hasVariable = this.hasVariableOnScope(task, name, scope);
        if (isNew && hasVariable) {
            throw new ResourceException(new Status(Status.CLIENT_ERROR_CONFLICT.getCode(), "Variable '" + name + "' is already present on task '" + task.getId() + "'.", null, null));
        }
        if (!isNew && !hasVariable) {
            throw new ActivitiObjectNotFoundException("Task '" + task.getId() + "' doesn't have a variable with name: '" + name + "'.", null);
        }
        if (scope == RestVariable.RestVariableScope.LOCAL) {
            ActivitiUtil.getTaskService().setVariableLocal(task.getId(), name, value);
        } else if (task.getExecutionId() != null) {
            ActivitiUtil.getRuntimeService().setVariable(task.getExecutionId(), name, value);
        } else {
            throw new ActivitiIllegalArgumentException("Cannot set global variable '" + name + "' on task '" + task.getId() + "', task is not part of process.");
        }
    }
}

