/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.management;

import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ManagementService;
import org.activiti.engine.runtime.Job;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class JobExceptionStacktraceResource {
    @Autowired
    protected ManagementService managementService;

    @RequestMapping(value={"/management/jobs/{jobId}/exception-stacktrace"}, method={RequestMethod.GET})
    public String getJobStacktrace(@PathVariable String jobId, HttpServletResponse response) {
        Job job = this.getJobFromResponse(jobId);
        String stackTrace = this.managementService.getJobExceptionStacktrace(job.getId());
        if (stackTrace == null) {
            throw new ActivitiObjectNotFoundException("Job with id '" + job.getId() + "' doesn't have an exception stacktrace.", String.class);
        }
        response.setContentType("text/plain");
        return stackTrace;
    }

    protected Job getJobFromResponse(String jobId) {
        Job job = (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
        if (job == null) {
            throw new ActivitiObjectNotFoundException("Could not find a job with id '" + jobId + "'.", Job.class);
        }
        return job;
    }
}

