/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.definition;

import java.util.List;
import org.activiti.workflow.simple.exception.SimpleWorkflowException;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class HumanStepAssignment {
    protected String assignee;
    protected List<String> candidateUsers;
    protected List<String> candidateGroups;
    protected HumanStepAssignmentType type = HumanStepAssignmentType.INITIATOR;

    public HumanStepAssignmentType getType() {
        return this.type;
    }

    public void setType(HumanStepAssignmentType type) {
        this.type = type;
        switch (type) {
            case GROUPS: {
                this.candidateUsers = null;
                this.assignee = null;
                break;
            }
            case INITIATOR: {
                this.candidateGroups = null;
                this.candidateUsers = null;
                this.assignee = null;
                break;
            }
            case MIXED: {
                this.assignee = null;
                break;
            }
            case USER: {
                this.candidateGroups = null;
                this.candidateUsers = null;
                break;
            }
            case USERS: {
                this.candidateGroups = null;
                this.assignee = null;
            }
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
        if (assignee != null) {
            this.setType(HumanStepAssignmentType.USER);
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public List<String> getCandidateGroups() {
        return this.candidateGroups;
    }

    public void setCandidateGroups(List<String> candidateGroups) {
        this.candidateGroups = candidateGroups;
        if (candidateGroups != null && candidateGroups.size() > 0) {
            if (this.candidateUsers != null && this.candidateUsers.size() > 0) {
                this.setType(HumanStepAssignmentType.MIXED);
            } else {
                this.setType(HumanStepAssignmentType.GROUPS);
            }
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public List<String> getCandidateUsers() {
        return this.candidateUsers;
    }

    public void setCandidateUsers(List<String> candidateUsers) {
        this.candidateUsers = candidateUsers;
        if (candidateUsers != null && candidateUsers.size() > 0) {
            if (this.candidateGroups != null && this.candidateGroups.size() > 0) {
                this.setType(HumanStepAssignmentType.MIXED);
            } else {
                this.setType(HumanStepAssignmentType.USERS);
            }
        }
    }

    public static enum HumanStepAssignmentType {
        INITIATOR,
        USER,
        USERS,
        GROUPS,
        MIXED;


        @JsonValue
        public String toString() {
            return this.name().toLowerCase();
        }

        @JsonCreator
        public static HumanStepAssignmentType forSimpleName(String name) {
            for (HumanStepAssignmentType type : HumanStepAssignmentType.values()) {
                if (!type.toString().equals(name)) continue;
                return type;
            }
            throw new SimpleWorkflowException("Invalid assignment type for human step: " + name);
        }
    }
}

