/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client;

import alluxio.Configuration;
import alluxio.util.ThreadFactoryUtils;
import alluxio.worker.ClientMetrics;
import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ClientContext {
    private static ExecutorService sExecutorService;
    private static Configuration sConf;
    private static InetSocketAddress sMasterAddress;
    private static ClientMetrics sClientMetrics;

    private static void reset() {
        sConf = new Configuration();
        ClientContext.init();
    }

    public static void init() {
        String masterHostname = (String)Preconditions.checkNotNull((Object)sConf.get("alluxio.master.hostname"));
        int masterPort = sConf.getInt("alluxio.master.port");
        sMasterAddress = new InetSocketAddress(masterHostname, masterPort);
        sClientMetrics = new ClientMetrics();
        sExecutorService = Executors.newFixedThreadPool(sConf.getInt("alluxio.user.block.worker.client.threads"), ThreadFactoryUtils.build((String)"block-worker-heartbeat-%d", (boolean)true));
    }

    public static Configuration getConf() {
        return sConf;
    }

    public static ClientMetrics getClientMetrics() {
        return sClientMetrics;
    }

    public static InetSocketAddress getMasterAddress() {
        return sMasterAddress;
    }

    public static ExecutorService getExecutorService() {
        return sExecutorService;
    }

    private ClientContext() {
    }

    static {
        ClientContext.reset();
    }
}

