/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client;

import alluxio.AlluxioURI;
import alluxio.client.ReadType;
import alluxio.client.WriteType;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.CreateFileOptions;
import alluxio.client.file.options.OpenFileOptions;
import alluxio.exception.AlluxioException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FileSystemTestUtils {
    public static void createByteFile(FileSystem fs, String fileName, int len, CreateFileOptions options) throws IOException {
        FileSystemTestUtils.createByteFile(fs, new AlluxioURI(fileName), options, len);
    }

    public static void createByteFile(FileSystem fs, String fileName, WriteType writeType, int len) throws IOException {
        FileSystemTestUtils.createByteFile(fs, new AlluxioURI(fileName), writeType, len);
    }

    public static void createByteFile(FileSystem fs, AlluxioURI fileURI, WriteType writeType, int len) throws IOException {
        CreateFileOptions options = CreateFileOptions.defaults().setWriteType(writeType);
        FileSystemTestUtils.createByteFile(fs, fileURI, options, len);
    }

    public static void createByteFile(FileSystem fs, AlluxioURI fileURI, CreateFileOptions options, int len) throws IOException {
        try {
            FileOutStream os = fs.createFile(fileURI, options);
            byte[] arr = new byte[len];
            for (int k = 0; k < len; ++k) {
                arr[k] = (byte)k;
            }
            os.write(arr);
            os.close();
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static void createByteFile(FileSystem fs, String fileName, WriteType writeType, int len, long blockCapacityByte) throws IOException {
        CreateFileOptions options = CreateFileOptions.defaults().setWriteType(writeType).setBlockSizeBytes(blockCapacityByte);
        FileSystemTestUtils.createByteFile(fs, new AlluxioURI(fileName), options, len);
    }

    public static List<String> listFiles(FileSystem fs, String path) throws IOException {
        try {
            List<URIStatus> statuses = fs.listStatus(new AlluxioURI(path));
            ArrayList<String> res = new ArrayList<String>();
            for (URIStatus status : statuses) {
                res.add(status.getPath());
                if (!status.isFolder()) continue;
                res.addAll(FileSystemTestUtils.listFiles(fs, status.getPath()));
            }
            return res;
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static OpenFileOptions toOpenFileOptions(CreateFileOptions op) {
        if (op.getAlluxioStorageType().isStore()) {
            return OpenFileOptions.defaults().setReadType(ReadType.CACHE);
        }
        return OpenFileOptions.defaults().setReadType(ReadType.NO_CACHE);
    }

    private FileSystemTestUtils() {
    }
}

