/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.Version;
import alluxio.client.file.FileSystem;
import alluxio.collections.Pair;
import alluxio.collections.PrefixList;
import alluxio.exception.AlluxioException;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.io.PathUtils;
import alluxio.util.network.NetworkAddressUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class UfsUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");

    private static AlluxioURI buildTFSPath(AlluxioURI tfsRootPath, AlluxioURI ufsRootPath, AlluxioURI path) {
        String filePath = path.getPath().substring(ufsRootPath.getPath().length());
        if (filePath.isEmpty()) {
            filePath = path.getPath().substring(ufsRootPath.getPath().lastIndexOf("/") + 1);
        }
        return new AlluxioURI(PathUtils.concatPath((Object)tfsRootPath, (Object[])new Object[]{filePath}));
    }

    private static void loadUfs(AlluxioURI tfsAddrRootPath, AlluxioURI ufsAddrRootPath, String excludePaths, Configuration configuration) throws IOException, AlluxioException {
        FileSystem tfs = FileSystem.Factory.get();
        PrefixList excludePathPrefix = new PrefixList(excludePaths, ";");
        UfsUtils.loadUfs(tfs, tfsAddrRootPath, ufsAddrRootPath, excludePathPrefix, configuration);
    }

    @Deprecated
    public static void loadUfs(FileSystem fs, AlluxioURI alluxioPath, AlluxioURI ufsAddrRootPath, PrefixList excludePathPrefix, Configuration conf) throws IOException, AlluxioException {
        int lastSlashPos;
        LOG.info("Loading to {} {} {}", new Object[]{alluxioPath, ufsAddrRootPath, excludePathPrefix});
        try {
            ufsAddrRootPath = NetworkAddressUtils.replaceHostName((AlluxioURI)ufsAddrRootPath);
            alluxioPath = NetworkAddressUtils.replaceHostName((AlluxioURI)alluxioPath);
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to resolve hostname", (Throwable)e);
            throw new IOException(e);
        }
        Pair ufsPair = UnderFileSystem.parse((AlluxioURI)ufsAddrRootPath, (Configuration)conf);
        String ufsAddress = (String)ufsPair.getFirst();
        String ufsRootPath = (String)ufsPair.getSecond();
        LOG.debug("Loading ufs, address:{}; root path: {}", (Object)ufsAddress, (Object)ufsRootPath);
        UnderFileSystem ufs = UnderFileSystem.get((String)ufsAddress, (Configuration)conf);
        if (!ufs.exists(ufsAddrRootPath.toString())) {
            throw new FileNotFoundException("ufs path " + ufsAddrRootPath + " not found.");
        }
        AlluxioURI directoryName = ufs.isFile(ufsAddrRootPath.toString()) ? (ufsRootPath == null || ufsRootPath.isEmpty() || ufsRootPath.equals("/") ? AlluxioURI.EMPTY_URI : ((lastSlashPos = ufsRootPath.lastIndexOf(47)) > 0 ? new AlluxioURI(ufsRootPath.substring(0, lastSlashPos)) : AlluxioURI.EMPTY_URI)) : alluxioPath;
        if (!directoryName.equals((Object)AlluxioURI.EMPTY_URI) && !fs.exists(directoryName)) {
            LOG.debug("Loading ufs. Make dir if needed for '{}'.", (Object)directoryName);
            fs.createDirectory(directoryName);
        }
        LinkedList<AlluxioURI> ufsPathQueue = new LinkedList<AlluxioURI>();
        if (excludePathPrefix.outList(ufsRootPath)) {
            ufsPathQueue.add(ufsAddrRootPath);
        }
        while (!ufsPathQueue.isEmpty()) {
            AlluxioURI ufsPath = (AlluxioURI)ufsPathQueue.poll();
            LOG.debug("Loading: {}", (Object)ufsPath);
            if (ufs.isFile(ufsPath.toString())) {
                AlluxioURI tfsPath = UfsUtils.buildTFSPath(directoryName, ufsAddrRootPath, ufsPath);
                LOG.debug("Loading ufs. fs path = {}.", (Object)tfsPath);
                if (fs.exists(tfsPath)) {
                    LOG.debug("File {} already exists in Alluxio.", (Object)tfsPath);
                    continue;
                }
                fs.loadMetadata(tfsPath);
                LOG.debug("Create alluxio file {} with checkpoint location {}", (Object)tfsPath, (Object)ufsPath);
                continue;
            }
            LOG.debug("Loading ufs. ufs path is a directory.");
            String[] files = ufs.list(ufsPath.toString());
            if (files != null) {
                for (String filePath : files) {
                    if (filePath.isEmpty()) continue;
                    LOG.debug("Get: {}", (Object)filePath);
                    String aPath = PathUtils.concatPath((Object)ufsPath, (Object[])new Object[]{filePath});
                    String checkPath = aPath.substring(ufsAddrRootPath.toString().length());
                    if (checkPath.startsWith("/")) {
                        checkPath = checkPath.substring("/".length());
                    }
                    if (excludePathPrefix.inList(checkPath)) {
                        LOG.debug("excluded: {}", (Object)checkPath);
                        continue;
                    }
                    ufsPathQueue.add(new AlluxioURI(aPath));
                }
            }
            AlluxioURI tfsPath = new AlluxioURI(PathUtils.concatPath((Object)alluxioPath, (Object[])new Object[]{ufsPath.getPath().substring(ufsAddrRootPath.getPath().length())}));
            LOG.debug("Loading ufs. ufs path is a directory. tfsPath = {}.", (Object)tfsPath);
            if (fs.exists(tfsPath)) continue;
            LOG.debug("Loading ufs. ufs path is a directory. make dir = {}.", (Object)tfsPath);
            fs.loadMetadata(tfsPath);
        }
    }

    public static void main(String[] args) {
        if (args.length != 2 && args.length != 3) {
            UfsUtils.printUsage();
            System.exit(-1);
        }
        String exList = args.length == 3 ? args[2] : "";
        try {
            UfsUtils.loadUfs(new AlluxioURI(args[0]), new AlluxioURI(args[1]), exList, new Configuration());
        }
        catch (Exception e) {
            e.printStackTrace();
            UfsUtils.printUsage();
            System.exit(-1);
        }
        System.exit(0);
    }

    public static void printUsage() {
        String cmd = "java -cp " + Version.ALLUXIO_JAR + " alluxio.client.UfsUtils ";
        System.out.println("Usage: " + cmd + "<AlluxioPath> <UfsPath> " + "[<Optional ExcludePathPrefix, separated by ;>]");
        System.out.println("Example: " + cmd + "alluxio://127.0.0.1:19998/a hdfs://localhost:9000/b c");
        System.out.println("Example: " + cmd + "alluxio://127.0.0.1:19998/a file:///b c");
        System.out.println("Example: " + cmd + "alluxio://127.0.0.1:19998/a /b c");
        System.out.print("In the TFS, all files under local FS /b will be registered under /a, ");
        System.out.println("except for those with prefix c");
    }

    private UfsUtils() {
    }
}

