/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.Configuration;
import alluxio.client.ClientContext;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.block.BlockStoreContext;
import alluxio.client.block.BlockWorkerClient;
import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.BufferedBlockInStream;
import alluxio.client.block.BufferedBlockOutStream;
import alluxio.client.block.LocalBlockInStream;
import alluxio.client.block.LocalBlockOutStream;
import alluxio.client.block.RemoteBlockInStream;
import alluxio.client.block.RemoteBlockOutStream;
import alluxio.exception.AlluxioException;
import alluxio.exception.ConnectionFailedException;
import alluxio.exception.ExceptionMessage;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockLocation;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class AlluxioBlockStore {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static AlluxioBlockStore sClient = null;
    private final BlockStoreContext mContext = BlockStoreContext.INSTANCE;

    public static synchronized AlluxioBlockStore get() {
        if (sClient == null) {
            sClient = new AlluxioBlockStore();
        }
        return sClient;
    }

    private AlluxioBlockStore() {
    }

    public BlockInfo getInfo(long blockId) throws IOException {
        BlockMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            BlockInfo blockInfo = masterClient.getBlockInfo(blockId);
            return blockInfo;
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BlockWorkerInfo> getWorkerInfoList() throws IOException, AlluxioException {
        ArrayList infoList = Lists.newArrayList();
        BlockMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            for (WorkerInfo workerInfo : masterClient.getWorkerInfoList()) {
                infoList.add(new BlockWorkerInfo(workerInfo.getAddress(), workerInfo.getCapacityBytes(), workerInfo.getUsedBytes()));
            }
            ArrayList arrayList = infoList;
            return arrayList;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    public BufferedBlockInStream getInStream(long blockId) throws IOException {
        BlockInfo blockInfo;
        BlockMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            blockInfo = masterClient.getBlockInfo(blockId);
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
        if (blockInfo.getLocations().isEmpty()) {
            throw new IOException("Block " + blockId + " is not available in Alluxio");
        }
        String localHostName = NetworkAddressUtils.getLocalHostName((Configuration)ClientContext.getConf());
        for (BlockLocation location : blockInfo.getLocations()) {
            WorkerNetAddress workerNetAddress = location.getWorkerAddress();
            if (!workerNetAddress.getHost().equals(localHostName)) continue;
            try {
                return new LocalBlockInStream(blockId, blockInfo.getLength());
            }
            catch (IOException e) {
                LOG.warn("Failed to open local stream for block " + blockId + ". " + e.getMessage());
                break;
            }
        }
        WorkerNetAddress workerNetAddress = ((BlockLocation)blockInfo.getLocations().get(0)).getWorkerAddress();
        return new RemoteBlockInStream(blockId, blockInfo.getLength(), new InetSocketAddress(workerNetAddress.getHost(), workerNetAddress.getDataPort()));
    }

    public BufferedBlockOutStream getOutStream(long blockId, long blockSize, WorkerNetAddress address) throws IOException {
        if (blockSize == -1L) {
            BlockMasterClient blockMasterClient = this.mContext.acquireMasterClient();
            try {
                blockSize = blockMasterClient.getBlockInfo(blockId).getLength();
            }
            catch (AlluxioException e) {
                throw new IOException(e);
            }
            finally {
                this.mContext.releaseMasterClient(blockMasterClient);
            }
        }
        if (address == null) {
            throw new RuntimeException(ExceptionMessage.NO_WORKER_AVAILABLE.getMessage(new Object[0]));
        }
        if (NetworkAddressUtils.getLocalHostName((Configuration)ClientContext.getConf()).equals(address.getHost())) {
            if (this.mContext.hasLocalWorker()) {
                return new LocalBlockOutStream(blockId, blockSize);
            }
            throw new IOException(ExceptionMessage.NO_LOCAL_WORKER.getMessage(new Object[]{"write"}));
        }
        return new RemoteBlockOutStream(blockId, blockSize, address);
    }

    public long getCapacityBytes() throws IOException {
        BlockMasterClient blockMasterClient = this.mContext.acquireMasterClient();
        try {
            long l = blockMasterClient.getCapacityBytes();
            return l;
        }
        catch (ConnectionFailedException e) {
            throw new IOException(e);
        }
        finally {
            this.mContext.releaseMasterClient(blockMasterClient);
        }
    }

    public long getUsedBytes() throws IOException {
        BlockMasterClient blockMasterClient = this.mContext.acquireMasterClient();
        try {
            long l = blockMasterClient.getUsedBytes();
            return l;
        }
        catch (ConnectionFailedException e) {
            throw new IOException(e);
        }
        finally {
            this.mContext.releaseMasterClient(blockMasterClient);
        }
    }

    public void promote(long blockId) throws IOException {
        BlockInfo info;
        BlockMasterClient blockMasterClient = this.mContext.acquireMasterClient();
        try {
            info = blockMasterClient.getBlockInfo(blockId);
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
        finally {
            this.mContext.releaseMasterClient(blockMasterClient);
        }
        if (info.getLocations().isEmpty()) {
            return;
        }
        WorkerNetAddress workerAddr = ((BlockLocation)info.getLocations().get(0)).getWorkerAddress();
        BlockWorkerClient blockWorkerClient = this.mContext.acquireWorkerClient(workerAddr.getHost());
        try {
            blockWorkerClient.promoteBlock(blockId);
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
        finally {
            this.mContext.releaseWorkerClient(blockWorkerClient);
        }
    }
}

