/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.AbstractClient;
import alluxio.AbstractMasterClient;
import alluxio.Configuration;
import alluxio.exception.AlluxioException;
import alluxio.exception.ConnectionFailedException;
import alluxio.thrift.AlluxioService;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.BlockMasterClientService;
import alluxio.wire.BlockInfo;
import alluxio.wire.ThriftUtils;
import alluxio.wire.WorkerInfo;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.thrift.TException;

@ThreadSafe
public final class BlockMasterClient
extends AbstractMasterClient {
    private BlockMasterClientService.Client mClient = null;

    public BlockMasterClient(InetSocketAddress masterAddress, Configuration configuration) {
        super(masterAddress, configuration);
    }

    protected AlluxioService.Client getClient() {
        return this.mClient;
    }

    protected String getServiceName() {
        return "BlockMasterClient";
    }

    protected long getServiceVersion() {
        return 1L;
    }

    protected void afterConnect() throws IOException {
        this.mClient = new BlockMasterClientService.Client(this.mProtocol);
    }

    public synchronized List<WorkerInfo> getWorkerInfoList() throws IOException, ConnectionFailedException {
        return (List)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<List<WorkerInfo>>(){

            public List<WorkerInfo> call() throws TException {
                ArrayList<WorkerInfo> result = new ArrayList<WorkerInfo>();
                for (alluxio.thrift.WorkerInfo workerInfo : BlockMasterClient.this.mClient.getWorkerInfoList()) {
                    result.add(ThriftUtils.fromThrift((alluxio.thrift.WorkerInfo)workerInfo));
                }
                return result;
            }
        });
    }

    public synchronized BlockInfo getBlockInfo(final long blockId) throws AlluxioException, IOException {
        return (BlockInfo)this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<BlockInfo>(){

            public BlockInfo call() throws AlluxioTException, TException {
                return ThriftUtils.fromThrift((alluxio.thrift.BlockInfo)BlockMasterClient.this.mClient.getBlockInfo(blockId));
            }
        });
    }

    public synchronized long getCapacityBytes() throws ConnectionFailedException, IOException {
        return (Long)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<Long>(){

            public Long call() throws TException {
                return BlockMasterClient.this.mClient.getCapacityBytes();
            }
        });
    }

    public synchronized long getUsedBytes() throws ConnectionFailedException, IOException {
        return (Long)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<Long>(){

            public Long call() throws TException {
                return BlockMasterClient.this.mClient.getUsedBytes();
            }
        });
    }
}

