/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.Configuration;
import alluxio.client.ClientContext;
import alluxio.client.ClientUtils;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.block.BlockMasterClientPool;
import alluxio.client.block.BlockWorkerClient;
import alluxio.client.block.BlockWorkerClientPool;
import alluxio.exception.ExceptionMessage;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.ClientMetrics;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public enum BlockStoreContext {
    INSTANCE;

    private BlockMasterClientPool mBlockMasterClientPool;
    private BlockWorkerClientPool mLocalBlockWorkerClientPool;
    private boolean mLocalBlockWorkerClientPoolInitialized = false;

    private BlockStoreContext() {
        this.reset();
    }

    private synchronized void initializeLocalBlockWorkerClientPool() {
        if (!this.mLocalBlockWorkerClientPoolInitialized) {
            WorkerNetAddress localWorkerAddress = this.getWorkerAddress(NetworkAddressUtils.getLocalHostName((Configuration)ClientContext.getConf()));
            this.mLocalBlockWorkerClientPool = localWorkerAddress == null ? null : new BlockWorkerClientPool(localWorkerAddress);
            this.mLocalBlockWorkerClientPoolInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkerNetAddress getWorkerAddress(String hostname) {
        BlockMasterClient masterClient = this.acquireMasterClient();
        try {
            List<WorkerInfo> workers = masterClient.getWorkerInfoList();
            if (hostname.isEmpty() && !workers.isEmpty()) {
                WorkerNetAddress workerNetAddress = workers.get(0).getAddress();
                return workerNetAddress;
            }
            for (WorkerInfo worker : workers) {
                if (!worker.getAddress().getHost().equals(hostname)) continue;
                WorkerNetAddress workerNetAddress = worker.getAddress();
                return workerNetAddress;
            }
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        finally {
            this.releaseMasterClient(masterClient);
        }
        return null;
    }

    public BlockMasterClient acquireMasterClient() {
        return (BlockMasterClient)((Object)this.mBlockMasterClientPool.acquire());
    }

    public void releaseMasterClient(BlockMasterClient masterClient) {
        this.mBlockMasterClientPool.release((Object)masterClient);
    }

    public BlockWorkerClient acquireWorkerClient() {
        BlockWorkerClient client = this.acquireLocalWorkerClient();
        if (client == null) {
            return this.acquireRemoteWorkerClient("");
        }
        return client;
    }

    public BlockWorkerClient acquireWorkerClient(String hostname) throws IOException {
        BlockWorkerClient client;
        if (hostname.equals(NetworkAddressUtils.getLocalHostName((Configuration)ClientContext.getConf()))) {
            client = this.acquireLocalWorkerClient();
            if (client == null) {
                throw new IOException(ExceptionMessage.NO_WORKER_AVAILABLE_ON_HOST.getMessage(new Object[]{hostname}));
            }
        } else {
            client = this.acquireRemoteWorkerClient(hostname);
        }
        return client;
    }

    public BlockWorkerClient acquireWorkerClient(WorkerNetAddress address) throws IOException {
        BlockWorkerClient client;
        if (address == null) {
            throw new RuntimeException(ExceptionMessage.NO_WORKER_AVAILABLE.getMessage(new Object[0]));
        }
        if (address.getHost().equals(NetworkAddressUtils.getLocalHostName((Configuration)ClientContext.getConf()))) {
            client = this.acquireLocalWorkerClient();
            if (client == null) {
                throw new IOException(ExceptionMessage.NO_WORKER_AVAILABLE_ON_HOST.getMessage(new Object[]{address.getHost()}));
            }
        } else {
            client = this.acquireRemoteWorkerClient(address);
        }
        return client;
    }

    public BlockWorkerClient acquireLocalWorkerClient() {
        this.initializeLocalBlockWorkerClientPool();
        if (this.mLocalBlockWorkerClientPool == null) {
            return null;
        }
        return (BlockWorkerClient)((Object)this.mLocalBlockWorkerClientPool.acquire());
    }

    private BlockWorkerClient acquireRemoteWorkerClient(String hostname) {
        WorkerNetAddress workerAddress = this.getWorkerAddress(hostname);
        return this.acquireRemoteWorkerClient(workerAddress);
    }

    private BlockWorkerClient acquireRemoteWorkerClient(WorkerNetAddress address) {
        if (address == null) {
            throw new RuntimeException(ExceptionMessage.NO_WORKER_AVAILABLE.getMessage(new Object[0]));
        }
        Preconditions.checkArgument((!address.getHost().equals(NetworkAddressUtils.getLocalHostName((Configuration)ClientContext.getConf())) ? 1 : 0) != 0, (Object)"Acquire Remote Worker Client cannot not be called with local hostname");
        long clientId = ClientUtils.getRandomNonNegativeLong();
        return new BlockWorkerClient(address, ClientContext.getExecutorService(), ClientContext.getConf(), clientId, false, new ClientMetrics());
    }

    public void releaseWorkerClient(BlockWorkerClient blockWorkerClient) {
        if (blockWorkerClient.isLocal()) {
            Preconditions.checkState((this.mLocalBlockWorkerClientPool != null ? 1 : 0) != 0);
            this.mLocalBlockWorkerClientPool.release(blockWorkerClient);
        } else {
            blockWorkerClient.close();
        }
    }

    public boolean hasLocalWorker() {
        this.initializeLocalBlockWorkerClientPool();
        return this.mLocalBlockWorkerClientPool != null;
    }

    @SuppressFBWarnings
    public void reset() {
        if (this.mBlockMasterClientPool != null) {
            this.mBlockMasterClientPool.close();
        }
        if (this.mLocalBlockWorkerClientPool != null) {
            this.mLocalBlockWorkerClientPool.close();
        }
        this.mBlockMasterClientPool = new BlockMasterClientPool(ClientContext.getMasterAddress());
        this.mLocalBlockWorkerClientPoolInitialized = false;
    }
}

