/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.AbstractClient;
import alluxio.Configuration;
import alluxio.client.block.BlockWorkerClientHeartbeatExecutor;
import alluxio.exception.AlluxioException;
import alluxio.exception.ConnectionFailedException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.WorkerOutOfSpaceException;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.heartbeat.HeartbeatThread;
import alluxio.security.authentication.AuthenticationUtils;
import alluxio.thrift.AlluxioService;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.BlockWorkerClientService;
import alluxio.thrift.LockBlockResult;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.ThriftUtils;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.ClientMetrics;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class BlockWorkerClient
extends AbstractClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final int CONNECTION_RETRY_TIMES = 5;
    private final boolean mIsLocal;
    private BlockWorkerClientService.Client mClient;
    private long mSessionId;
    private InetSocketAddress mWorkerDataServerAddress;
    private final ExecutorService mExecutorService;
    private final HeartbeatExecutor mHeartbeatExecutor;
    private Future<?> mHeartbeat;
    private final ClientMetrics mClientMetrics;

    public BlockWorkerClient(WorkerNetAddress workerNetAddress, ExecutorService executorService, Configuration conf, long sessionId, boolean isLocal, ClientMetrics clientMetrics) {
        super(NetworkAddressUtils.getRpcPortSocketAddress((WorkerNetAddress)workerNetAddress), conf, "blockWorker");
        this.mWorkerDataServerAddress = NetworkAddressUtils.getDataPortSocketAddress((WorkerNetAddress)workerNetAddress);
        this.mExecutorService = (ExecutorService)Preconditions.checkNotNull((Object)executorService);
        this.mSessionId = sessionId;
        this.mIsLocal = isLocal;
        this.mClientMetrics = (ClientMetrics)Preconditions.checkNotNull((Object)clientMetrics);
        this.mHeartbeatExecutor = new BlockWorkerClientHeartbeatExecutor(this);
    }

    public synchronized void accessBlock(final long blockId) throws ConnectionFailedException, IOException {
        this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<Void>(){

            public Void call() throws TException {
                BlockWorkerClient.this.mClient.accessBlock(blockId);
                return null;
            }
        });
    }

    public synchronized boolean asyncCheckpoint(final long fileId) throws IOException, AlluxioException {
        return (Boolean)this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Boolean>(){

            public Boolean call() throws AlluxioTException, TException {
                return BlockWorkerClient.this.mClient.asyncCheckpoint(fileId);
            }
        });
    }

    public synchronized void cacheBlock(final long blockId) throws IOException, AlluxioException {
        this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Void>(){

            public Void call() throws AlluxioTException, TException {
                BlockWorkerClient.this.mClient.cacheBlock(BlockWorkerClient.this.mSessionId, blockId);
                return null;
            }
        });
    }

    public synchronized void cancelBlock(final long blockId) throws IOException, AlluxioException {
        this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Void>(){

            public Void call() throws AlluxioTException, TException {
                BlockWorkerClient.this.mClient.cancelBlock(BlockWorkerClient.this.mSessionId, blockId);
                return null;
            }
        });
    }

    protected synchronized void beforeDisconnect() {
        if (this.mHeartbeatExecutor != null) {
            this.mHeartbeatExecutor.heartbeat();
        }
    }

    protected synchronized void afterDisconnect() {
        if (this.mHeartbeat != null) {
            this.mHeartbeat.cancel(true);
        }
    }

    protected synchronized AlluxioService.Client getClient() {
        return this.mClient;
    }

    protected String getServiceName() {
        return "BlockWorkerClient";
    }

    protected long getServiceVersion() {
        return 1L;
    }

    private synchronized void connectOperation() throws IOException {
        if (!this.mConnected) {
            LOG.info("Connecting to {} worker @ {}", (Object)(this.mIsLocal ? "local" : "remote"), (Object)this.mAddress);
            TBinaryProtocol binaryProtocol = new TBinaryProtocol(AuthenticationUtils.getClientTransport((Configuration)this.mConfiguration, (InetSocketAddress)this.mAddress));
            this.mProtocol = new TMultiplexedProtocol((TProtocol)binaryProtocol, this.getServiceName());
            this.mClient = new BlockWorkerClientService.Client(this.mProtocol);
            try {
                this.mProtocol.getTransport().open();
            }
            catch (TTransportException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return;
            }
            this.mConnected = true;
            if (this.mHeartbeat == null || this.mHeartbeat.isCancelled() || this.mHeartbeat.isDone()) {
                int interval = this.mConfiguration.getInt("alluxio.user.heartbeat.interval.ms");
                this.mHeartbeat = this.mExecutorService.submit((Runnable)new HeartbeatThread("Worker Client", this.mHeartbeatExecutor, (long)interval));
            }
        }
    }

    public synchronized void createNewSession(long newSessionId) {
        this.mSessionId = newSessionId;
    }

    public synchronized InetSocketAddress getAddress() {
        return this.mAddress;
    }

    public synchronized InetSocketAddress getDataServerAddress() {
        return this.mWorkerDataServerAddress;
    }

    public synchronized long getSessionId() {
        return this.mSessionId;
    }

    public synchronized boolean isLocal() {
        return this.mIsLocal;
    }

    public synchronized alluxio.wire.LockBlockResult lockBlock(final long blockId) throws IOException {
        try {
            return (alluxio.wire.LockBlockResult)this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<alluxio.wire.LockBlockResult>(){

                public alluxio.wire.LockBlockResult call() throws AlluxioTException, TException {
                    return ThriftUtils.fromThrift((LockBlockResult)BlockWorkerClient.this.mClient.lockBlock(blockId, BlockWorkerClient.this.mSessionId));
                }
            });
        }
        catch (AlluxioException e) {
            if (e instanceof FileDoesNotExistException) {
                return null;
            }
            throw new IOException(e);
        }
    }

    public synchronized void connect() throws IOException {
        int tries = 0;
        while (tries++ <= 5) {
            this.connectOperation();
            if (!this.isConnected()) continue;
            return;
        }
        throw new IOException("Failed to connect to the worker");
    }

    public synchronized boolean promoteBlock(final long blockId) throws IOException, AlluxioException {
        return (Boolean)this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Boolean>(){

            public Boolean call() throws AlluxioTException, TException {
                return BlockWorkerClient.this.mClient.promoteBlock(blockId);
            }
        });
    }

    public synchronized String requestBlockLocation(final long blockId, final long initialBytes) throws IOException {
        try {
            return (String)this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<String>(){

                public String call() throws AlluxioTException, TException {
                    return BlockWorkerClient.this.mClient.requestBlockLocation(BlockWorkerClient.this.mSessionId, blockId, initialBytes);
                }
            });
        }
        catch (AlluxioException e) {
            if (e instanceof WorkerOutOfSpaceException) {
                throw new IOException("Failed to request " + initialBytes, e);
            }
            throw new IOException(e);
        }
    }

    public synchronized boolean requestSpace(final long blockId, final long requestBytes) throws IOException {
        try {
            return (Boolean)this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Boolean>(){

                public Boolean call() throws AlluxioTException, TException {
                    return BlockWorkerClient.this.mClient.requestSpace(BlockWorkerClient.this.mSessionId, blockId, requestBytes);
                }
            });
        }
        catch (AlluxioException e) {
            if (e instanceof WorkerOutOfSpaceException) {
                return false;
            }
            throw new IOException(e);
        }
    }

    public synchronized boolean unlockBlock(final long blockId) throws ConnectionFailedException, IOException {
        return (Boolean)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<Boolean>(){

            public Boolean call() throws TException {
                return BlockWorkerClient.this.mClient.unlockBlock(blockId, BlockWorkerClient.this.mSessionId);
            }
        });
    }

    public synchronized void sessionHeartbeat() throws ConnectionFailedException, IOException {
        this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<Void>(){

            public Void call() throws TException {
                BlockWorkerClient.this.mClient.sessionHeartbeat(BlockWorkerClient.this.mSessionId, BlockWorkerClient.this.mClientMetrics.getHeartbeatData());
                return null;
            }
        });
    }

    public synchronized void periodicHeartbeat() {
        block2: {
            try {
                this.sessionHeartbeat();
            }
            catch (Exception e) {
                LOG.error("Periodic heartbeat failed, cleaning up.", (Throwable)e);
                if (this.mHeartbeat == null) break block2;
                this.mHeartbeat.cancel(true);
                this.mHeartbeat = null;
            }
        }
    }
}

