/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.client.ClientContext;
import alluxio.client.ClientUtils;
import alluxio.client.block.BlockWorkerClient;
import alluxio.resource.ResourcePool;
import alluxio.wire.WorkerNetAddress;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
final class BlockWorkerClientPool
extends ResourcePool<BlockWorkerClient> {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final WorkerNetAddress mWorkerNetAddress;

    public BlockWorkerClientPool(WorkerNetAddress workerAddress) {
        super(ClientContext.getConf().getInt("alluxio.user.block.worker.client.threads"));
        this.mWorkerNetAddress = workerAddress;
    }

    public void close() {
    }

    public void release(BlockWorkerClient blockWorkerClient) {
        try {
            blockWorkerClient.sessionHeartbeat();
        }
        catch (Exception e) {
            LOG.warn("Failed sending client metrics before releasing the worker client", (Throwable)e);
        }
        blockWorkerClient.createNewSession(ClientUtils.getRandomNonNegativeLong());
        super.release((Object)blockWorkerClient);
    }

    protected BlockWorkerClient createNewResource() {
        long clientId = ClientUtils.getRandomNonNegativeLong();
        return new BlockWorkerClient(this.mWorkerNetAddress, ClientContext.getExecutorService(), ClientContext.getConf(), clientId, true, ClientContext.getClientMetrics());
    }
}

