/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.Configuration;
import alluxio.client.ClientContext;
import alluxio.client.block.BlockInStream;
import alluxio.util.io.BufferUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class BufferedBlockInStream
extends BlockInStream {
    private long mPos;
    private boolean mBufferIsValid;
    protected final long mBlockId;
    protected final long mBlockSize;
    protected ByteBuffer mBuffer;
    protected boolean mClosed;
    protected boolean mBlockIsRead;

    public BufferedBlockInStream(long blockId, long blockSize) {
        this.mBlockId = blockId;
        this.mBlockSize = blockSize;
        this.mBuffer = this.allocateBuffer();
        this.mBufferIsValid = false;
        this.mClosed = false;
        this.mBlockIsRead = false;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
    }

    @Override
    public int read() throws IOException {
        this.checkIfClosed();
        if (this.remaining() == 0L) {
            this.close();
            return -1;
        }
        if (!this.mBufferIsValid || this.mBuffer.remaining() == 0) {
            this.updateBuffer();
        }
        ++this.mPos;
        this.mBlockIsRead = true;
        return BufferUtils.byteToInt((byte)this.mBuffer.get());
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkIfClosed();
        Preconditions.checkArgument((b != null ? 1 : 0) != 0, (Object)"Read buffer cannot be null");
        Preconditions.checkArgument((off >= 0 && len >= 0 && len + off <= b.length ? 1 : 0) != 0, (String)"Buffer length: %s, offset: %s, len: %s", (Object[])new Object[]{b.length, off, len});
        if (len == 0) {
            return 0;
        }
        if (this.remaining() == 0L) {
            return -1;
        }
        int toRead = (int)Math.min((long)len, this.remaining());
        if (this.mBufferIsValid && this.mBuffer.remaining() > toRead) {
            this.mBuffer.get(b, off, toRead);
            this.mPos += (long)toRead;
            this.mBlockIsRead = true;
            return toRead;
        }
        if (toRead > this.mBuffer.capacity() / 2) {
            this.mBufferIsValid = false;
            int bytesRead = this.directRead(b, off, toRead);
            this.mPos += (long)bytesRead;
            this.mBlockIsRead = true;
            this.incrementBytesReadMetric(bytesRead);
            return bytesRead;
        }
        this.updateBuffer();
        this.mBuffer.get(b, off, toRead);
        this.mPos += (long)toRead;
        this.mBlockIsRead = true;
        return toRead;
    }

    @Override
    public long remaining() {
        return this.mBlockSize - this.mPos;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.checkIfClosed();
        Preconditions.checkArgument((pos >= 0L ? 1 : 0) != 0, (String)"Seek position is negative: %s", (Object[])new Object[]{pos});
        Preconditions.checkArgument((pos <= this.mBlockSize ? 1 : 0) != 0, (String)"Seek position past end of block: %s", (Object[])new Object[]{this.mBlockSize});
        this.mBufferIsValid = false;
        this.mPos = pos;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkIfClosed();
        if (n <= 0L) {
            return 0L;
        }
        long toSkip = Math.min(this.remaining(), n);
        this.mBufferIsValid = false;
        this.mPos += toSkip;
        return toSkip;
    }

    protected long getPosition() {
        return this.mPos;
    }

    protected abstract void bufferedRead(int var1) throws IOException;

    protected abstract int directRead(byte[] var1, int var2, int var3) throws IOException;

    protected abstract void incrementBytesReadMetric(int var1);

    private ByteBuffer allocateBuffer() {
        Configuration conf = ClientContext.getConf();
        return ByteBuffer.allocate((int)conf.getBytes("alluxio.user.block.remote.read.buffer.size.bytes"));
    }

    private void checkIfClosed() {
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"Cannot do operations on a closed BlockInStream");
    }

    private void updateBuffer() throws IOException {
        int toRead = (int)Math.min((long)this.mBuffer.capacity(), this.remaining());
        this.bufferedRead(toRead);
        Preconditions.checkState((this.mBuffer.remaining() == toRead ? 1 : 0) != 0);
        this.mBufferIsValid = true;
        this.incrementBytesReadMetric(toRead);
    }
}

