/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.Configuration;
import alluxio.client.Cancelable;
import alluxio.client.ClientContext;
import alluxio.client.block.BlockStoreContext;
import alluxio.util.io.BufferUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class BufferedBlockOutStream
extends OutputStream
implements Cancelable {
    protected final long mBlockId;
    protected final long mBlockSize;
    protected final BlockStoreContext mContext;
    protected final ByteBuffer mBuffer;
    protected boolean mClosed;
    protected long mFlushedBytes;
    protected long mWrittenBytes;

    public BufferedBlockOutStream(long blockId, long blockSize) {
        this.mBlockId = blockId;
        this.mBlockSize = blockSize;
        this.mBuffer = this.allocateBuffer();
        this.mClosed = false;
        this.mContext = BlockStoreContext.INSTANCE;
    }

    public long remaining() {
        return this.mBlockSize - this.mWrittenBytes;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkIfClosed();
        Preconditions.checkState((this.mWrittenBytes + 1L <= this.mBlockSize ? 1 : 0) != 0, (Object)"Cannot write past end of block");
        if (this.mBuffer.position() >= this.mBuffer.limit()) {
            this.flush();
        }
        BufferUtils.putIntByteBuffer((ByteBuffer)this.mBuffer, (int)b);
        ++this.mWrittenBytes;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.mBuffer.position() > 0 && this.mBuffer.position() + len > this.mBuffer.limit()) {
            this.flush();
        }
        if (len > this.mBuffer.limit() / 2) {
            if (this.mBuffer.position() > 0) {
                this.flush();
            }
            this.unBufferedWrite(b, off, len);
        } else {
            this.mBuffer.put(b, off, len);
        }
        this.mWrittenBytes += (long)len;
    }

    protected void checkIfClosed() {
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"Cannot do operations on a closed BlockOutStream");
    }

    protected abstract void unBufferedWrite(byte[] var1, int var2, int var3) throws IOException;

    private ByteBuffer allocateBuffer() {
        Configuration conf = ClientContext.getConf();
        return ByteBuffer.allocate((int)conf.getBytes("alluxio.user.file.buffer.bytes"));
    }
}

