/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.Configuration;
import alluxio.client.ClientContext;
import alluxio.client.block.BlockStoreContext;
import alluxio.client.block.BlockWorkerClient;
import alluxio.client.block.BufferedBlockInStream;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.util.io.BufferUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.LockBlockResult;
import alluxio.worker.block.io.LocalFileBlockReader;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class LocalBlockInStream
extends BufferedBlockInStream {
    private final Closer mCloser;
    private final BlockWorkerClient mBlockWorkerClient;
    private final BlockStoreContext mContext = BlockStoreContext.INSTANCE;
    private final LocalFileBlockReader mReader;

    public LocalBlockInStream(long blockId, long blockSize) throws IOException {
        super(blockId, blockSize);
        this.mCloser = Closer.create();
        this.mBlockWorkerClient = this.mContext.acquireWorkerClient(NetworkAddressUtils.getLocalHostName((Configuration)ClientContext.getConf()));
        try {
            LockBlockResult result = this.mBlockWorkerClient.lockBlock(blockId);
            if (result == null) {
                throw new IOException(ExceptionMessage.BLOCK_NOT_LOCALLY_AVAILABLE.getMessage(new Object[]{this.mBlockId}));
            }
            this.mReader = new LocalFileBlockReader(result.getBlockPath());
            this.mCloser.register((Closeable)this.mReader);
        }
        catch (IOException e) {
            this.mContext.releaseWorkerClient(this.mBlockWorkerClient);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        try {
            if (this.mBlockIsRead) {
                this.mBlockWorkerClient.accessBlock(this.mBlockId);
                ClientContext.getClientMetrics().incBlocksReadLocal(1L);
            }
            this.mBlockWorkerClient.unlockBlock(this.mBlockId);
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
        finally {
            this.mContext.releaseWorkerClient(this.mBlockWorkerClient);
            this.mCloser.close();
            if (this.mBuffer != null && this.mBuffer.isDirect()) {
                BufferUtils.cleanDirectBuffer((ByteBuffer)this.mBuffer);
            }
        }
        this.mClosed = true;
    }

    @Override
    protected void bufferedRead(int len) throws IOException {
        if (this.mBuffer.isDirect()) {
            BufferUtils.cleanDirectBuffer((ByteBuffer)this.mBuffer);
        }
        this.mBuffer = this.mReader.read(this.getPosition(), (long)len);
    }

    @Override
    public int directRead(byte[] b, int off, int len) throws IOException {
        ByteBuffer buf = this.mReader.read(this.getPosition(), (long)len);
        buf.get(b, off, len);
        BufferUtils.cleanDirectBuffer((ByteBuffer)buf);
        return len;
    }

    @Override
    protected void incrementBytesReadMetric(int bytes) {
        ClientContext.getClientMetrics().incBytesReadLocal((long)bytes);
    }
}

