/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.Configuration;
import alluxio.client.ClientContext;
import alluxio.client.block.BlockWorkerClient;
import alluxio.client.block.BufferedBlockOutStream;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.util.io.FileUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.worker.block.io.LocalFileBlockWriter;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class LocalBlockOutStream
extends BufferedBlockOutStream {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final Closer mCloser = Closer.create();
    private final BlockWorkerClient mBlockWorkerClient = this.mContext.acquireWorkerClient(NetworkAddressUtils.getLocalHostName((Configuration)ClientContext.getConf()));
    private final LocalFileBlockWriter mWriter;
    private long mReservedBytes;

    public LocalBlockOutStream(long blockId, long blockSize) throws IOException {
        super(blockId, blockSize);
        try {
            long initialSize = ClientContext.getConf().getBytes("alluxio.user.file.buffer.bytes");
            String blockPath = this.mBlockWorkerClient.requestBlockLocation(this.mBlockId, initialSize);
            this.mReservedBytes += initialSize;
            FileUtils.createBlockPath((String)blockPath);
            this.mWriter = new LocalFileBlockWriter(blockPath);
            this.mCloser.register((Closeable)this.mWriter);
            FileUtils.changeLocalFileToFullPermission((String)blockPath);
            LOG.info("LocalBlockOutStream created new file block, block path: {}", (Object)blockPath);
        }
        catch (IOException e) {
            this.mContext.releaseWorkerClient(this.mBlockWorkerClient);
            throw e;
        }
    }

    @Override
    public void cancel() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mCloser.close();
        try {
            this.mBlockWorkerClient.cancelBlock(this.mBlockId);
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
        this.mContext.releaseWorkerClient(this.mBlockWorkerClient);
        this.mClosed = true;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.flush();
        this.mCloser.close();
        if (this.mWrittenBytes > 0L) {
            try {
                this.mBlockWorkerClient.cacheBlock(this.mBlockId);
            }
            catch (AlluxioException e) {
                throw new IOException(e);
            }
            ClientContext.getClientMetrics().incBlocksWrittenLocal(1L);
        }
        this.mContext.releaseWorkerClient(this.mBlockWorkerClient);
        this.mClosed = true;
    }

    @Override
    public void flush() throws IOException {
        int bytesToWrite = this.mBuffer.position();
        if (this.mReservedBytes < (long)bytesToWrite) {
            this.mReservedBytes += this.requestSpace((long)bytesToWrite - this.mReservedBytes);
        }
        this.mBuffer.flip();
        this.mWriter.append(this.mBuffer);
        this.mBuffer.clear();
        this.mReservedBytes -= (long)bytesToWrite;
        this.mFlushedBytes += (long)bytesToWrite;
        ClientContext.getClientMetrics().incBytesWrittenLocal((long)bytesToWrite);
    }

    @Override
    protected void unBufferedWrite(byte[] b, int off, int len) throws IOException {
        if (this.mReservedBytes < (long)len) {
            this.mReservedBytes += this.requestSpace((long)len - this.mReservedBytes);
        }
        this.mWriter.append(ByteBuffer.wrap(b, off, len));
        this.mReservedBytes -= (long)len;
        this.mFlushedBytes += (long)len;
        ClientContext.getClientMetrics().incBytesWrittenLocal((long)len);
    }

    private long requestSpace(long requestBytes) throws IOException {
        if (!this.mBlockWorkerClient.requestSpace(this.mBlockId, requestBytes)) {
            throw new IOException(ExceptionMessage.CANNOT_REQUEST_SPACE.getMessage(new Object[0]));
        }
        return requestBytes;
    }
}

