/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.client.ClientContext;
import alluxio.client.RemoteBlockReader;
import alluxio.client.block.BlockStoreContext;
import alluxio.client.block.BlockWorkerClient;
import alluxio.client.block.BufferedBlockInStream;
import alluxio.exception.ConnectionFailedException;
import alluxio.exception.ExceptionMessage;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class RemoteBlockInStream
extends BufferedBlockInStream {
    private final InetSocketAddress mLocation;
    private final Long mLockId;
    private final BlockWorkerClient mBlockWorkerClient;
    private final BlockStoreContext mContext;

    public RemoteBlockInStream(long blockId, long blockSize, InetSocketAddress location) throws IOException {
        super(blockId, blockSize);
        this.mLocation = location;
        this.mContext = BlockStoreContext.INSTANCE;
        this.mBlockWorkerClient = this.mContext.acquireWorkerClient(location.getHostName());
        try {
            this.mLockId = this.mBlockWorkerClient.lockBlock(blockId).getLockId();
            if (this.mLockId == null) {
                throw new IOException(ExceptionMessage.BLOCK_UNAVAILABLE.getMessage(new Object[]{blockId}));
            }
        }
        catch (IOException e) {
            this.mContext.releaseWorkerClient(this.mBlockWorkerClient);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        ClientContext.getClientMetrics().incBlocksReadRemote(1L);
        try {
            this.mBlockWorkerClient.unlockBlock(this.mBlockId);
        }
        catch (ConnectionFailedException e) {
            throw new IOException(e);
        }
        finally {
            this.mContext.releaseWorkerClient(this.mBlockWorkerClient);
        }
        this.mClosed = true;
    }

    @Override
    protected void bufferedRead(int len) throws IOException {
        this.mBuffer.clear();
        int bytesRead = this.readFromRemote(this.mBuffer.array(), 0, len);
        this.mBuffer.limit(bytesRead);
    }

    @Override
    protected int directRead(byte[] b, int off, int len) throws IOException {
        return this.readFromRemote(b, off, len);
    }

    @Override
    protected void incrementBytesReadMetric(int bytes) {
        ClientContext.getClientMetrics().incBytesReadRemote((long)bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readFromRemote(byte[] b, int off, int len) throws IOException {
        int toRead;
        int bytesLeft = toRead = (int)Math.min((long)len, this.remaining());
        while (bytesLeft > 0) {
            try (RemoteBlockReader reader = RemoteBlockReader.Factory.create(ClientContext.getConf());){
                ByteBuffer data = reader.readRemoteBlock(this.mLocation, this.mBlockId, this.getPosition(), bytesLeft, this.mLockId, this.mBlockWorkerClient.getSessionId());
                int bytesRead = data.remaining();
                data.get(b, off, bytesRead);
                bytesLeft -= bytesRead;
                this.incrementBytesReadMetric(bytesRead);
            }
        }
        return toRead;
    }
}

