/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.client.ClientContext;
import alluxio.client.RemoteBlockWriter;
import alluxio.client.block.BlockWorkerClient;
import alluxio.client.block.BufferedBlockOutStream;
import alluxio.exception.AlluxioException;
import alluxio.wire.WorkerNetAddress;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class RemoteBlockOutStream
extends BufferedBlockOutStream {
    private final RemoteBlockWriter mRemoteWriter = RemoteBlockWriter.Factory.create(ClientContext.getConf());
    private final BlockWorkerClient mBlockWorkerClient;

    public RemoteBlockOutStream(long blockId, long blockSize) throws IOException {
        super(blockId, blockSize);
        this.mBlockWorkerClient = this.mContext.acquireWorkerClient();
        try {
            this.mBlockWorkerClient.connect();
            this.mRemoteWriter.open(this.mBlockWorkerClient.getDataServerAddress(), this.mBlockId, this.mBlockWorkerClient.getSessionId());
        }
        catch (IOException e) {
            this.mContext.releaseWorkerClient(this.mBlockWorkerClient);
            throw e;
        }
    }

    public RemoteBlockOutStream(long blockId, long blockSize, WorkerNetAddress address) throws IOException {
        super(blockId, blockSize);
        this.mBlockWorkerClient = this.mContext.acquireWorkerClient(address);
        try {
            this.mBlockWorkerClient.connect();
            this.mRemoteWriter.open(this.mBlockWorkerClient.getDataServerAddress(), this.mBlockId, this.mBlockWorkerClient.getSessionId());
        }
        catch (IOException e) {
            this.mContext.releaseWorkerClient(this.mBlockWorkerClient);
            throw e;
        }
    }

    @Override
    public void cancel() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mRemoteWriter.close();
        try {
            this.mBlockWorkerClient.cancelBlock(this.mBlockId);
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
        this.mContext.releaseWorkerClient(this.mBlockWorkerClient);
        this.mClosed = true;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.flush();
        this.mRemoteWriter.close();
        if (this.mFlushedBytes > 0L) {
            try {
                this.mBlockWorkerClient.cacheBlock(this.mBlockId);
            }
            catch (AlluxioException e) {
                throw new IOException(e);
            }
            ClientContext.getClientMetrics().incBlocksWrittenRemote(1L);
        } else {
            try {
                this.mBlockWorkerClient.cancelBlock(this.mBlockId);
            }
            catch (AlluxioException e) {
                throw new IOException(e);
            }
        }
        this.mContext.releaseWorkerClient(this.mBlockWorkerClient);
        this.mClosed = true;
    }

    @Override
    public void flush() throws IOException {
        this.writeToRemoteBlock(this.mBuffer.array(), 0, this.mBuffer.position());
        this.mBuffer.clear();
    }

    @Override
    protected void unBufferedWrite(byte[] b, int off, int len) throws IOException {
        this.writeToRemoteBlock(b, off, len);
    }

    private void writeToRemoteBlock(byte[] b, int off, int len) throws IOException {
        this.mRemoteWriter.write(b, off, len);
        this.mFlushedBytes += (long)len;
        ClientContext.getClientMetrics().incBytesWrittenRemote((long)len);
    }
}

