/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.Configuration;
import alluxio.client.ClientContext;
import alluxio.client.block.BlockInStream;
import alluxio.exception.ExceptionMessage;
import alluxio.underfs.UnderFileSystem;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class UnderStoreBlockInStream
extends BlockInStream {
    private final long mInitPos;
    private final long mLength;
    private final String mUfsPath;
    private long mPos;
    private InputStream mUnderStoreStream;

    public UnderStoreBlockInStream(long initPos, long length, String ufsPath) throws IOException {
        this.mInitPos = initPos;
        this.mLength = length;
        this.mUfsPath = ufsPath;
        this.setUnderStoreStream(initPos);
    }

    @Override
    public void close() throws IOException {
        this.mUnderStoreStream.close();
    }

    @Override
    public int read() throws IOException {
        int data = this.mUnderStoreStream.read();
        ++this.mPos;
        return data;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int data = this.mUnderStoreStream.read(b);
        ++this.mPos;
        return data;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.mUnderStoreStream.read(b, off, len);
        this.mPos += (long)bytesRead;
        return bytesRead;
    }

    @Override
    public long remaining() {
        return this.mInitPos + this.mLength - this.mPos;
    }

    @Override
    public void seek(long pos) throws IOException {
        long offset = this.mPos - this.mInitPos;
        if (pos < offset) {
            this.setUnderStoreStream(pos);
        } else {
            long toSkip = pos - offset;
            if (this.skip(toSkip) != toSkip) {
                throw new IOException(ExceptionMessage.FAILED_SEEK_FORWARD.getMessage(new Object[]{pos}));
            }
        }
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped;
        if (n <= 0L) {
            return 0L;
        }
        long toSkip = Math.min(this.mInitPos + this.mLength - this.mPos, n);
        if (toSkip != (skipped = this.mUnderStoreStream.skip(toSkip))) {
            throw new IOException(ExceptionMessage.FAILED_SKIP.getMessage(new Object[]{toSkip}));
        }
        this.mPos += skipped;
        return skipped;
    }

    private void setUnderStoreStream(long pos) throws IOException {
        if (this.mUnderStoreStream != null) {
            this.mUnderStoreStream.close();
        }
        UnderFileSystem ufs = UnderFileSystem.get((String)this.mUfsPath, (Configuration)ClientContext.getConf());
        this.mUnderStoreStream = ufs.open(this.mUfsPath);
        this.mPos = 0L;
        if (pos != this.skip(pos)) {
            throw new IOException(ExceptionMessage.FAILED_SKIP.getMessage(new Object[]{pos}));
        }
    }
}

