/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.CreateDirectoryOptions;
import alluxio.client.file.options.CreateFileOptions;
import alluxio.client.file.options.DeleteOptions;
import alluxio.client.file.options.ExistsOptions;
import alluxio.client.file.options.FreeOptions;
import alluxio.client.file.options.GetStatusOptions;
import alluxio.client.file.options.ListStatusOptions;
import alluxio.client.file.options.LoadMetadataOptions;
import alluxio.client.file.options.MountOptions;
import alluxio.client.file.options.OpenFileOptions;
import alluxio.client.file.options.RenameOptions;
import alluxio.client.file.options.SetAttributeOptions;
import alluxio.client.file.options.UnmountOptions;
import alluxio.exception.AlluxioException;
import alluxio.exception.DirectoryNotEmptyException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class BaseFileSystem
implements FileSystem {
    private final FileSystemContext mContext = FileSystemContext.INSTANCE;

    public static BaseFileSystem get() {
        return new BaseFileSystem();
    }

    protected BaseFileSystem() {
    }

    @Override
    public void createDirectory(AlluxioURI path) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
        this.createDirectory(path, CreateDirectoryOptions.defaults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDirectory(AlluxioURI path, CreateDirectoryOptions options) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            masterClient.createDirectory(path, options);
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public FileOutStream createFile(AlluxioURI path) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
        return this.createFile(path, CreateFileOptions.defaults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileOutStream createFile(AlluxioURI path, CreateFileOptions options) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            masterClient.createFile(path, options);
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
        return new FileOutStream(path, options.toOutStreamOptions());
    }

    @Override
    public void delete(AlluxioURI path) throws DirectoryNotEmptyException, FileDoesNotExistException, IOException, AlluxioException {
        this.delete(path, DeleteOptions.defaults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(AlluxioURI path, DeleteOptions options) throws DirectoryNotEmptyException, FileDoesNotExistException, IOException, AlluxioException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            masterClient.delete(path, options);
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public boolean exists(AlluxioURI path) throws InvalidPathException, IOException, AlluxioException {
        return this.exists(path, ExistsOptions.defaults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(AlluxioURI path, ExistsOptions options) throws InvalidPathException, IOException, AlluxioException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            masterClient.getStatus(path);
            boolean bl = true;
            return bl;
        }
        catch (FileDoesNotExistException e) {
            boolean bl = false;
            return bl;
        }
        catch (InvalidPathException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public void free(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
        this.free(path, FreeOptions.defaults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(AlluxioURI path, FreeOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            masterClient.free(path, options);
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public URIStatus getStatus(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
        return this.getStatus(path, GetStatusOptions.defaults());
    }

    @Override
    public URIStatus getStatus(AlluxioURI path, GetStatusOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            URIStatus uRIStatus = masterClient.getStatus(path);
            return uRIStatus;
        }
        catch (FileDoesNotExistException e) {
            throw new FileDoesNotExistException(ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{path}));
        }
        catch (InvalidPathException e) {
            throw new FileDoesNotExistException(ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{path}));
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public List<URIStatus> listStatus(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
        return this.listStatus(path, ListStatusOptions.defaults());
    }

    @Override
    public List<URIStatus> listStatus(AlluxioURI path, ListStatusOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            List<URIStatus> list = masterClient.listStatus(path);
            return list;
        }
        catch (FileDoesNotExistException e) {
            throw new FileDoesNotExistException(ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{path}));
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public void loadMetadata(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
        this.loadMetadata(path, LoadMetadataOptions.defaults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadMetadata(AlluxioURI path, LoadMetadataOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            masterClient.loadMetadata(path, options);
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public void mount(AlluxioURI src, AlluxioURI dst) throws IOException, AlluxioException {
        this.mount(src, dst, MountOptions.defaults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mount(AlluxioURI src, AlluxioURI dst, MountOptions options) throws IOException, AlluxioException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            masterClient.mount(src, dst);
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public FileInStream openFile(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
        return this.openFile(path, OpenFileOptions.defaults());
    }

    @Override
    public FileInStream openFile(AlluxioURI path, OpenFileOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        URIStatus status = this.getStatus(path);
        if (status.isFolder()) {
            throw new FileNotFoundException(ExceptionMessage.CANNOT_READ_DIRECTORY.getMessage(new Object[]{status.getName()}));
        }
        return new FileInStream(status, options.toInStreamOptions());
    }

    @Override
    public void rename(AlluxioURI src, AlluxioURI dst) throws FileDoesNotExistException, IOException, AlluxioException {
        this.rename(src, dst, RenameOptions.defaults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(AlluxioURI src, AlluxioURI dst, RenameOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            masterClient.rename(src, dst);
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public void setAttribute(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
        this.setAttribute(path, SetAttributeOptions.defaults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(AlluxioURI path, SetAttributeOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            masterClient.setAttribute(path, options);
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public void unmount(AlluxioURI path) throws IOException, AlluxioException {
        this.unmount(path, UnmountOptions.defaults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmount(AlluxioURI path, UnmountOptions options) throws IOException, AlluxioException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            masterClient.unmount(path);
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }
}

