/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.AbstractOutStream;
import alluxio.client.AlluxioStorageType;
import alluxio.client.ClientContext;
import alluxio.client.ClientUtils;
import alluxio.client.UnderStorageType;
import alluxio.client.block.BufferedBlockOutStream;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.CompleteFileOptions;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.client.file.policy.FileWriteLocationPolicy;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.io.PathUtils;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class FileOutStream
extends AbstractOutStream {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final long mBlockSize;
    protected final AlluxioStorageType mAlluxioStorageType;
    private final UnderStorageType mUnderStorageType;
    private final FileSystemContext mContext;
    private final OutputStream mUnderStorageOutputStream;
    private final long mNonce;
    private String mUfsPath;
    private FileWriteLocationPolicy mLocationPolicy;
    protected boolean mCanceled;
    protected boolean mClosed;
    private boolean mShouldCacheCurrentBlock;
    protected BufferedBlockOutStream mCurrentBlockOutStream;
    protected List<BufferedBlockOutStream> mPreviousBlockOutStreams;
    protected final AlluxioURI mUri;

    public FileOutStream(AlluxioURI path, OutStreamOptions options) throws IOException {
        this.mUri = (AlluxioURI)Preconditions.checkNotNull((Object)path);
        this.mNonce = ClientUtils.getRandomNonNegativeLong();
        this.mBlockSize = options.getBlockSizeBytes();
        this.mAlluxioStorageType = options.getAlluxioStorageType();
        this.mUnderStorageType = options.getUnderStorageType();
        this.mContext = FileSystemContext.INSTANCE;
        this.mPreviousBlockOutStreams = new LinkedList<BufferedBlockOutStream>();
        if (this.mUnderStorageType.isSyncPersist()) {
            this.updateUfsPath();
            String tmpPath = PathUtils.temporaryFileName((long)this.mNonce, (String)this.mUfsPath);
            UnderFileSystem ufs = UnderFileSystem.get((String)tmpPath, (Configuration)ClientContext.getConf());
            this.mUnderStorageOutputStream = ufs.create(tmpPath, (int)this.mBlockSize);
        } else {
            this.mUfsPath = null;
            this.mUnderStorageOutputStream = null;
        }
        this.mClosed = false;
        this.mCanceled = false;
        this.mShouldCacheCurrentBlock = this.mAlluxioStorageType.isStore();
        this.mBytesWritten = 0;
        this.mLocationPolicy = (FileWriteLocationPolicy)Preconditions.checkNotNull((Object)options.getLocationPolicy(), (Object)"The location policy is not specified");
    }

    @Override
    public void cancel() throws IOException {
        this.mCanceled = true;
        this.close();
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        if (this.mCurrentBlockOutStream != null) {
            this.mPreviousBlockOutStreams.add(this.mCurrentBlockOutStream);
        }
        Boolean canComplete = false;
        CompleteFileOptions options = CompleteFileOptions.defaults();
        if (this.mUnderStorageType.isSyncPersist()) {
            String tmpPath = PathUtils.temporaryFileName((long)this.mNonce, (String)this.mUfsPath);
            UnderFileSystem ufs = UnderFileSystem.get((String)tmpPath, (Configuration)ClientContext.getConf());
            if (this.mCanceled) {
                this.mUnderStorageOutputStream.close();
                if (!ufs.exists(tmpPath)) {
                    this.updateUfsPath();
                    tmpPath = PathUtils.temporaryFileName((long)this.mNonce, (String)this.mUfsPath);
                }
                ufs.delete(tmpPath, false);
            } else {
                this.mUnderStorageOutputStream.flush();
                this.mUnderStorageOutputStream.close();
                if (!ufs.exists(tmpPath)) {
                    this.updateUfsPath();
                    tmpPath = PathUtils.temporaryFileName((long)this.mNonce, (String)this.mUfsPath);
                }
                if (!ufs.rename(tmpPath, this.mUfsPath)) {
                    throw new IOException("Failed to rename " + tmpPath + " to " + this.mUfsPath);
                }
                options.setUfsLength(ufs.getFileSize(this.mUfsPath));
                canComplete = true;
            }
        }
        if (this.mAlluxioStorageType.isStore()) {
            try {
                if (this.mCanceled) {
                    for (BufferedBlockOutStream bos : this.mPreviousBlockOutStreams) {
                        bos.cancel();
                    }
                } else {
                    for (BufferedBlockOutStream bos : this.mPreviousBlockOutStreams) {
                        bos.close();
                    }
                    canComplete = true;
                }
            }
            catch (IOException e) {
                this.handleCacheWriteException(e);
            }
        }
        if (canComplete.booleanValue()) {
            FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
            try {
                masterClient.completeFile(this.mUri, options);
            }
            catch (AlluxioException e) {
                throw new IOException(e);
            }
            finally {
                this.mContext.releaseMasterClient(masterClient);
            }
        }
        if (this.mUnderStorageType.isAsyncPersist()) {
            this.scheduleAsyncPersist();
        }
        this.mClosed = true;
    }

    @Override
    public void flush() throws IOException {
        if (this.mUnderStorageType.isSyncPersist()) {
            this.mUnderStorageOutputStream.flush();
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.mShouldCacheCurrentBlock) {
            try {
                if (this.mCurrentBlockOutStream == null || this.mCurrentBlockOutStream.remaining() == 0L) {
                    this.getNextBlock();
                }
                this.mCurrentBlockOutStream.write(b);
            }
            catch (IOException e) {
                this.handleCacheWriteException(e);
            }
        }
        if (this.mUnderStorageType.isSyncPersist()) {
            this.mUnderStorageOutputStream.write(b);
            ClientContext.getClientMetrics().incBytesWrittenUfs(1L);
        }
        ++this.mBytesWritten;
    }

    @Override
    public void write(byte[] b) throws IOException {
        Preconditions.checkArgument((b != null ? 1 : 0) != 0, (Object)"Cannot write a null input buffer");
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Preconditions.checkArgument((b != null ? 1 : 0) != 0, (Object)"Cannot write a null input buffer");
        Preconditions.checkArgument((off >= 0 && len >= 0 && len + off <= b.length ? 1 : 0) != 0, (String)"Buffer length: %s, offset: %s, len: %s", (Object[])new Object[]{b.length, off, len});
        if (this.mShouldCacheCurrentBlock) {
            try {
                int tLen = len;
                int tOff = off;
                while (tLen > 0) {
                    long currentBlockLeftBytes;
                    if (this.mCurrentBlockOutStream == null || this.mCurrentBlockOutStream.remaining() == 0L) {
                        this.getNextBlock();
                    }
                    if ((currentBlockLeftBytes = this.mCurrentBlockOutStream.remaining()) >= (long)tLen) {
                        this.mCurrentBlockOutStream.write(b, tOff, tLen);
                        tLen = 0;
                        continue;
                    }
                    this.mCurrentBlockOutStream.write(b, tOff, (int)currentBlockLeftBytes);
                    tOff = (int)((long)tOff + currentBlockLeftBytes);
                    tLen = (int)((long)tLen - currentBlockLeftBytes);
                }
            }
            catch (IOException e) {
                this.handleCacheWriteException(e);
            }
        }
        if (this.mUnderStorageType.isSyncPersist()) {
            this.mUnderStorageOutputStream.write(b, off, len);
            ClientContext.getClientMetrics().incBytesWrittenUfs((long)len);
        }
        this.mBytesWritten += len;
    }

    private void getNextBlock() throws IOException {
        if (this.mCurrentBlockOutStream != null) {
            Preconditions.checkState((this.mCurrentBlockOutStream.remaining() <= 0L ? 1 : 0) != 0, (Object)"The current block still has space left, no need to get new block");
            this.mPreviousBlockOutStreams.add(this.mCurrentBlockOutStream);
        }
        if (this.mAlluxioStorageType.isStore()) {
            try {
                WorkerNetAddress address = this.mLocationPolicy.getWorkerForNextBlock(this.mContext.getAluxioBlockStore().getWorkerInfoList(), this.mBlockSize);
                this.mCurrentBlockOutStream = this.mContext.getAluxioBlockStore().getOutStream(this.getNextBlockId(), this.mBlockSize, address);
                this.mShouldCacheCurrentBlock = true;
            }
            catch (AlluxioException e) {
                throw new IOException(e);
            }
        }
    }

    private long getNextBlockId() throws IOException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            long l = masterClient.getNewBlockIdForFile(this.mUri);
            return l;
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    protected void handleCacheWriteException(IOException e) throws IOException {
        if (!this.mUnderStorageType.isSyncPersist()) {
            throw new IOException(ExceptionMessage.FAILED_CACHE.getMessage(new Object[]{e.getMessage()}), e);
        }
        LOG.warn("Failed to write into AlluxioStore, canceling write attempt.", (Throwable)e);
        if (this.mCurrentBlockOutStream != null) {
            this.mShouldCacheCurrentBlock = false;
            this.mCurrentBlockOutStream.cancel();
        }
    }

    private void updateUfsPath() throws IOException {
        FileSystemMasterClient client = this.mContext.acquireMasterClient();
        try {
            URIStatus status = client.getStatus(this.mUri);
            this.mUfsPath = status.getUfsPath();
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
        finally {
            this.mContext.releaseMasterClient(client);
        }
    }

    protected void scheduleAsyncPersist() throws IOException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            masterClient.scheduleAsyncPersist(this.mUri);
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }
}

