/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.ClientContext;
import alluxio.client.file.BaseFileSystem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.CreateDirectoryOptions;
import alluxio.client.file.options.CreateFileOptions;
import alluxio.client.file.options.DeleteOptions;
import alluxio.client.file.options.ExistsOptions;
import alluxio.client.file.options.FreeOptions;
import alluxio.client.file.options.GetStatusOptions;
import alluxio.client.file.options.ListStatusOptions;
import alluxio.client.file.options.LoadMetadataOptions;
import alluxio.client.file.options.MountOptions;
import alluxio.client.file.options.OpenFileOptions;
import alluxio.client.file.options.RenameOptions;
import alluxio.client.file.options.SetAttributeOptions;
import alluxio.client.file.options.UnmountOptions;
import alluxio.client.lineage.LineageFileSystem;
import alluxio.exception.AlluxioException;
import alluxio.exception.DirectoryNotEmptyException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import java.io.IOException;
import java.util.List;

public interface FileSystem {
    public void createDirectory(AlluxioURI var1) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException;

    public void createDirectory(AlluxioURI var1, CreateDirectoryOptions var2) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException;

    public FileOutStream createFile(AlluxioURI var1) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException;

    public FileOutStream createFile(AlluxioURI var1, CreateFileOptions var2) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException;

    public void delete(AlluxioURI var1) throws DirectoryNotEmptyException, FileDoesNotExistException, IOException, AlluxioException;

    public void delete(AlluxioURI var1, DeleteOptions var2) throws DirectoryNotEmptyException, FileDoesNotExistException, IOException, AlluxioException;

    public boolean exists(AlluxioURI var1) throws InvalidPathException, IOException, AlluxioException;

    public boolean exists(AlluxioURI var1, ExistsOptions var2) throws InvalidPathException, IOException, AlluxioException;

    public void free(AlluxioURI var1) throws FileDoesNotExistException, IOException, AlluxioException;

    public void free(AlluxioURI var1, FreeOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    public URIStatus getStatus(AlluxioURI var1) throws FileDoesNotExistException, IOException, AlluxioException;

    public URIStatus getStatus(AlluxioURI var1, GetStatusOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    public List<URIStatus> listStatus(AlluxioURI var1) throws FileDoesNotExistException, IOException, AlluxioException;

    public List<URIStatus> listStatus(AlluxioURI var1, ListStatusOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    public void loadMetadata(AlluxioURI var1) throws FileDoesNotExistException, IOException, AlluxioException;

    public void loadMetadata(AlluxioURI var1, LoadMetadataOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    public void mount(AlluxioURI var1, AlluxioURI var2) throws IOException, AlluxioException;

    public void mount(AlluxioURI var1, AlluxioURI var2, MountOptions var3) throws IOException, AlluxioException;

    public FileInStream openFile(AlluxioURI var1) throws FileDoesNotExistException, IOException, AlluxioException;

    public FileInStream openFile(AlluxioURI var1, OpenFileOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    public void rename(AlluxioURI var1, AlluxioURI var2) throws FileDoesNotExistException, IOException, AlluxioException;

    public void rename(AlluxioURI var1, AlluxioURI var2, RenameOptions var3) throws FileDoesNotExistException, IOException, AlluxioException;

    public void setAttribute(AlluxioURI var1) throws FileDoesNotExistException, IOException, AlluxioException;

    public void setAttribute(AlluxioURI var1, SetAttributeOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    public void unmount(AlluxioURI var1) throws IOException, AlluxioException;

    public void unmount(AlluxioURI var1, UnmountOptions var2) throws IOException, AlluxioException;

    public static class Factory {
        public static FileSystem get() {
            if (ClientContext.getConf().getBoolean("alluxio.user.lineage.enabled")) {
                return LineageFileSystem.get();
            }
            return BaseFileSystem.get();
        }
    }
}

