/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.client.ClientContext;
import alluxio.client.block.AlluxioBlockStore;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.FileSystemMasterClientPool;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public enum FileSystemContext {
    INSTANCE;

    private FileSystemMasterClientPool mFileSystemMasterClientPool = new FileSystemMasterClientPool(ClientContext.getMasterAddress());
    private final AlluxioBlockStore mAlluxioBlockStore = AlluxioBlockStore.get();

    public FileSystemMasterClient acquireMasterClient() {
        return (FileSystemMasterClient)((Object)this.mFileSystemMasterClientPool.acquire());
    }

    public void releaseMasterClient(FileSystemMasterClient masterClient) {
        this.mFileSystemMasterClientPool.release((Object)masterClient);
    }

    public AlluxioBlockStore getAluxioBlockStore() {
        return this.mAlluxioBlockStore;
    }

    public void reset() {
        this.mFileSystemMasterClientPool.close();
        this.mFileSystemMasterClientPool = new FileSystemMasterClientPool(ClientContext.getMasterAddress());
    }
}

