/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AbstractClient;
import alluxio.AbstractMasterClient;
import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.CompleteFileOptions;
import alluxio.client.file.options.CreateDirectoryOptions;
import alluxio.client.file.options.CreateFileOptions;
import alluxio.client.file.options.DeleteOptions;
import alluxio.client.file.options.FreeOptions;
import alluxio.client.file.options.LoadMetadataOptions;
import alluxio.client.file.options.SetAttributeOptions;
import alluxio.exception.AlluxioException;
import alluxio.exception.ConnectionFailedException;
import alluxio.thrift.AlluxioService;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.FileBlockInfo;
import alluxio.thrift.FileInfo;
import alluxio.thrift.FileSystemMasterClientService;
import alluxio.wire.ThriftUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.thrift.TException;

@ThreadSafe
public final class FileSystemMasterClient
extends AbstractMasterClient {
    private FileSystemMasterClientService.Client mClient = null;

    public FileSystemMasterClient(InetSocketAddress masterAddress, Configuration configuration) {
        super(masterAddress, configuration);
    }

    protected AlluxioService.Client getClient() {
        return this.mClient;
    }

    protected String getServiceName() {
        return "FileSystemMasterClient";
    }

    protected long getServiceVersion() {
        return 1L;
    }

    protected void afterConnect() throws IOException {
        this.mClient = new FileSystemMasterClientService.Client(this.mProtocol);
    }

    public synchronized void createDirectory(final AlluxioURI path, final CreateDirectoryOptions options) throws IOException, AlluxioException {
        this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Void>(){

            public Void call() throws AlluxioTException, TException {
                FileSystemMasterClient.this.mClient.createDirectory(path.getPath(), options.toThrift());
                return null;
            }
        });
    }

    public synchronized void createFile(final AlluxioURI path, final CreateFileOptions options) throws IOException, AlluxioException {
        this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Void>(){

            public Void call() throws AlluxioTException, TException {
                FileSystemMasterClient.this.mClient.createFile(path.getPath(), options.toThrift());
                return null;
            }
        });
    }

    public synchronized void completeFile(final AlluxioURI path, final CompleteFileOptions options) throws IOException, AlluxioException {
        this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Void>(){

            public Void call() throws AlluxioTException, TException {
                FileSystemMasterClient.this.mClient.completeFile(path.getPath(), options.toThrift());
                return null;
            }
        });
    }

    public synchronized void delete(final AlluxioURI path, final DeleteOptions options) throws IOException, AlluxioException {
        this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Void>(){

            public Void call() throws AlluxioTException, TException {
                FileSystemMasterClient.this.mClient.remove(path.getPath(), options.isRecursive());
                return null;
            }
        });
    }

    public synchronized void free(final AlluxioURI path, final FreeOptions options) throws IOException, AlluxioException {
        this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Void>(){

            public Void call() throws AlluxioTException, TException {
                FileSystemMasterClient.this.mClient.free(path.getPath(), options.isRecursive());
                return null;
            }
        });
    }

    public synchronized List<alluxio.wire.FileBlockInfo> getFileBlockInfoList(final AlluxioURI path) throws IOException, AlluxioException {
        return (List)this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<List<alluxio.wire.FileBlockInfo>>(){

            public List<alluxio.wire.FileBlockInfo> call() throws AlluxioTException, TException {
                ArrayList<alluxio.wire.FileBlockInfo> result = new ArrayList<alluxio.wire.FileBlockInfo>();
                for (FileBlockInfo fileBlockInfo : FileSystemMasterClient.this.mClient.getFileBlockInfoList(path.getPath())) {
                    result.add(ThriftUtils.fromThrift((FileBlockInfo)fileBlockInfo));
                }
                return result;
            }
        });
    }

    public synchronized URIStatus getStatus(final AlluxioURI path) throws IOException, AlluxioException {
        return (URIStatus)this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<URIStatus>(){

            public URIStatus call() throws AlluxioTException, TException {
                return new URIStatus(ThriftUtils.fromThrift((FileInfo)FileSystemMasterClient.this.mClient.getStatus(path.getPath())));
            }
        });
    }

    public synchronized URIStatus getStatusInternal(final long fileId) throws IOException, AlluxioException {
        return (URIStatus)this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<URIStatus>(){

            public URIStatus call() throws AlluxioTException, TException {
                return new URIStatus(ThriftUtils.fromThrift((FileInfo)FileSystemMasterClient.this.mClient.getStatusInternal(fileId)));
            }
        });
    }

    public synchronized long getNewBlockIdForFile(final AlluxioURI path) throws IOException, AlluxioException {
        return (Long)this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Long>(){

            public Long call() throws AlluxioTException, TException {
                return FileSystemMasterClient.this.mClient.getNewBlockIdForFile(path.getPath());
            }
        });
    }

    public synchronized String getUfsAddress() throws IOException, ConnectionFailedException {
        return (String)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<String>(){

            public String call() throws TException {
                return FileSystemMasterClient.this.mClient.getUfsAddress();
            }
        });
    }

    public synchronized List<URIStatus> listStatus(final AlluxioURI path) throws IOException, AlluxioException {
        return (List)this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<List<URIStatus>>(){

            public List<URIStatus> call() throws AlluxioTException, TException {
                ArrayList<URIStatus> result = new ArrayList<URIStatus>();
                for (FileInfo fileInfo : FileSystemMasterClient.this.mClient.listStatus(path.getPath())) {
                    result.add(new URIStatus(ThriftUtils.fromThrift((FileInfo)fileInfo)));
                }
                return result;
            }
        });
    }

    public synchronized void loadMetadata(final AlluxioURI path, final LoadMetadataOptions options) throws IOException, AlluxioException {
        this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Long>(){

            public Long call() throws AlluxioTException, TException {
                return FileSystemMasterClient.this.mClient.loadMetadata(path.toString(), options.isRecursive());
            }
        });
    }

    public synchronized void mount(final AlluxioURI alluxioPath, final AlluxioURI ufsPath) throws AlluxioException, IOException {
        this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Void>(){

            public Void call() throws AlluxioTException, TException {
                FileSystemMasterClient.this.mClient.mount(alluxioPath.toString(), ufsPath.toString());
                return null;
            }
        });
    }

    public synchronized void rename(final AlluxioURI src, final AlluxioURI dst) throws IOException, AlluxioException {
        this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Void>(){

            public Void call() throws AlluxioTException, TException {
                FileSystemMasterClient.this.mClient.rename(src.getPath(), dst.getPath());
                return null;
            }
        });
    }

    public synchronized void setAttribute(final AlluxioURI path, final SetAttributeOptions options) throws IOException, AlluxioException {
        this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Void>(){

            public Void call() throws AlluxioTException, TException {
                FileSystemMasterClient.this.mClient.setAttribute(path.getPath(), options.toThrift());
                return null;
            }
        });
    }

    public synchronized void scheduleAsyncPersist(final AlluxioURI path) throws AlluxioException, IOException {
        this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Void>(){

            public Void call() throws AlluxioTException, TException {
                FileSystemMasterClient.this.mClient.scheduleAsyncPersist(path.getPath());
                return null;
            }
        });
    }

    public synchronized void unmount(final AlluxioURI alluxioPath) throws AlluxioException, IOException {
        this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Void>(){

            public Void call() throws AlluxioTException, TException {
                FileSystemMasterClient.this.mClient.unmount(alluxioPath.toString());
                return null;
            }
        });
    }
}

