/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.ClientContext;
import alluxio.client.ReadType;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.OpenFileOptions;
import alluxio.client.file.options.SetAttributeOptions;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.CommonUtils;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class FileSystemUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");

    private FileSystemUtils() {
    }

    public static boolean waitCompleted(FileSystem fs, AlluxioURI uri) throws IOException, AlluxioException, InterruptedException {
        return FileSystemUtils.waitCompleted(fs, uri, -1L, TimeUnit.MILLISECONDS);
    }

    public static boolean waitCompleted(FileSystem fs, AlluxioURI uri, long timeout, TimeUnit tunit) throws IOException, AlluxioException, InterruptedException {
        long deadline = System.currentTimeMillis() + tunit.toMillis(timeout);
        long pollPeriod = ClientContext.getConf().getLong("alluxio.user.file.waitcompleted.poll.ms");
        boolean completed = false;
        long timeleft = deadline - System.currentTimeMillis();
        long toSleep = 0L;
        while (!(completed || timeout > 0L && timeleft <= 0L)) {
            if (!fs.exists(uri)) {
                LOG.debug("The file {} being waited upon does not exist yet. Waiting for it to be created.", (Object)uri);
            } else {
                completed = fs.getStatus(uri).isCompleted();
            }
            if (timeout == 0L) {
                return completed;
            }
            if (completed) continue;
            toSleep = timeout < 0L || timeleft > pollPeriod ? pollPeriod : timeleft;
            CommonUtils.sleepMs((Logger)LOG, (long)toSleep, (boolean)true);
            timeleft = deadline - System.currentTimeMillis();
        }
        return completed;
    }

    public static long persistFile(FileSystem fs, AlluxioURI uri, URIStatus status, Configuration conf) throws IOException, FileDoesNotExistException, AlluxioException {
        long ret;
        try (Closer closer = Closer.create();){
            OpenFileOptions options = OpenFileOptions.defaults().setReadType(ReadType.NO_CACHE);
            FileInStream in = (FileInStream)closer.register((Closeable)fs.openFile(uri, options));
            AlluxioURI dstPath = new AlluxioURI(status.getUfsPath());
            UnderFileSystem ufs = UnderFileSystem.get((String)dstPath.toString(), (Configuration)conf);
            String parentPath = dstPath.getParent().toString();
            if (!ufs.exists(parentPath) && !ufs.mkdirs(parentPath, true)) {
                throw new IOException("Failed to create " + parentPath);
            }
            OutputStream out = (OutputStream)closer.register((Closeable)ufs.create(dstPath.getPath()));
            ret = IOUtils.copyLarge((InputStream)in, (OutputStream)out);
        }
        fs.setAttribute(uri, SetAttributeOptions.defaults().setPersisted(true));
        return ret;
    }
}

