/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.wire.FileInfo;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class URIStatus {
    private final FileInfo mInfo;

    public URIStatus(FileInfo info) {
        this.mInfo = (FileInfo)Preconditions.checkNotNull((Object)info, (Object)"Cannot create a URIStatus from a null FileInfo");
    }

    public List<Long> getBlockIds() {
        return this.mInfo.getBlockIds();
    }

    public long getBlockSizeBytes() {
        return this.mInfo.getBlockSizeBytes();
    }

    public long getCreationTimeMs() {
        return this.mInfo.getCreationTimeMs();
    }

    public long getFileId() {
        return this.mInfo.getFileId();
    }

    public String getGroupName() {
        return this.mInfo.getGroupName();
    }

    public int getInMemoryPercentage() {
        return this.mInfo.getInMemoryPercentage();
    }

    public long getLastModificationTimeMs() {
        return this.mInfo.getLastModificationTimeMs();
    }

    public long getLength() {
        return this.mInfo.getLength();
    }

    public String getName() {
        return this.mInfo.getName();
    }

    public String getPath() {
        return this.mInfo.getPath();
    }

    public int getPermission() {
        return this.mInfo.getPermission();
    }

    public String getPersistenceState() {
        return this.mInfo.getPersistenceState();
    }

    public long getTtl() {
        return this.mInfo.getTtl();
    }

    public String getUfsPath() {
        return this.mInfo.getUfsPath();
    }

    public String getUserName() {
        return this.mInfo.getUserName();
    }

    public boolean isCacheable() {
        return this.mInfo.isCacheable();
    }

    public boolean isCompleted() {
        return this.mInfo.isCompleted();
    }

    public boolean isFolder() {
        return this.mInfo.isFolder();
    }

    public boolean isPersisted() {
        return this.mInfo.isPersisted();
    }

    public boolean isPinned() {
        return this.mInfo.isPinned();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof URIStatus)) {
            return false;
        }
        URIStatus that = (URIStatus)o;
        return this.mInfo.equals((Object)that.mInfo);
    }

    public int hashCode() {
        return this.mInfo.hashCode();
    }

    public String toString() {
        return this.mInfo.toString();
    }
}

