/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.client.ClientContext;
import alluxio.client.UnderStorageType;
import alluxio.client.WriteType;
import alluxio.thrift.CreateDirectoryTOptions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CreateDirectoryOptions {
    private boolean mAllowExists = false;
    private boolean mRecursive = false;
    private UnderStorageType mUnderStorageType;

    public static CreateDirectoryOptions defaults() {
        return new CreateDirectoryOptions();
    }

    private CreateDirectoryOptions() {
        WriteType defaultWriteType = (WriteType)ClientContext.getConf().getEnum("alluxio.user.file.writetype.default", WriteType.class);
        this.mUnderStorageType = defaultWriteType.getUnderStorageType();
    }

    public UnderStorageType getUnderStorageType() {
        return this.mUnderStorageType;
    }

    public boolean isAllowExists() {
        return this.mAllowExists;
    }

    public boolean isRecursive() {
        return this.mRecursive;
    }

    public CreateDirectoryOptions setAllowExists(boolean allowExists) {
        this.mAllowExists = allowExists;
        return this;
    }

    public CreateDirectoryOptions setRecursive(boolean recursive) {
        this.mRecursive = recursive;
        return this;
    }

    public CreateDirectoryOptions setWriteType(WriteType writeType) {
        this.mUnderStorageType = writeType.getUnderStorageType();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CreateDirectoryOptions(");
        sb.append(super.toString()).append(", AllowExists: ").append(this.mAllowExists);
        sb.append(", Recursive: ").append(this.mRecursive);
        sb.append(", UnderStorageType: ").append(this.mUnderStorageType.toString());
        sb.append(")");
        return sb.toString();
    }

    public CreateDirectoryTOptions toThrift() {
        CreateDirectoryTOptions options = new CreateDirectoryTOptions();
        options.setAllowExists(this.mAllowExists);
        options.setRecursive(this.mRecursive);
        options.setPersisted(this.mUnderStorageType.isSyncPersist());
        return options;
    }
}

