/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.Configuration;
import alluxio.client.AlluxioStorageType;
import alluxio.client.ClientContext;
import alluxio.client.UnderStorageType;
import alluxio.client.WriteType;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.client.file.policy.FileWriteLocationPolicy;
import alluxio.thrift.CreateFileTOptions;
import alluxio.util.CommonUtils;
import com.google.common.base.Throwables;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CreateFileOptions {
    private boolean mRecursive;
    private long mBlockSizeBytes;
    private FileWriteLocationPolicy mLocationPolicy;
    private long mTtl;
    private WriteType mWriteType;

    public static CreateFileOptions defaults() {
        return new CreateFileOptions();
    }

    private CreateFileOptions() {
        Configuration conf = ClientContext.getConf();
        this.mRecursive = true;
        this.mBlockSizeBytes = conf.getBytes("alluxio.user.block.size.bytes.default");
        try {
            this.mLocationPolicy = (FileWriteLocationPolicy)CommonUtils.createNewClassInstance((Class)conf.getClass("alluxio.user.file.write.location.policy.class"), (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.mWriteType = (WriteType)conf.getEnum("alluxio.user.file.writetype.default", WriteType.class);
        this.mTtl = -1L;
    }

    public long getBlockSizeBytes() {
        return this.mBlockSizeBytes;
    }

    public FileWriteLocationPolicy getLocationPolicy() {
        return this.mLocationPolicy;
    }

    public AlluxioStorageType getAlluxioStorageType() {
        return this.mWriteType.getAlluxioStorageType();
    }

    public long getTtl() {
        return this.mTtl;
    }

    public UnderStorageType getUnderStorageType() {
        return this.mWriteType.getUnderStorageType();
    }

    public boolean isRecursive() {
        return this.mRecursive;
    }

    public CreateFileOptions setBlockSizeBytes(long blockSizeBytes) {
        this.mBlockSizeBytes = blockSizeBytes;
        return this;
    }

    public CreateFileOptions setLocationPolicy(FileWriteLocationPolicy locationPolicy) {
        this.mLocationPolicy = locationPolicy;
        return this;
    }

    public CreateFileOptions setRecursive(boolean recursive) {
        this.mRecursive = recursive;
        return this;
    }

    public CreateFileOptions setTtl(long ttl) {
        this.mTtl = ttl;
        return this;
    }

    public CreateFileOptions setWriteType(WriteType writeType) {
        this.mWriteType = writeType;
        return this;
    }

    public OutStreamOptions toOutStreamOptions() {
        return OutStreamOptions.defaults().setBlockSizeBytes(this.mBlockSizeBytes).setLocationPolicy(this.mLocationPolicy).setTtl(this.mTtl).setWriteType(this.mWriteType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CreateFileOptions(");
        sb.append(super.toString()).append(", BlockSizeBytes: ").append(this.mBlockSizeBytes);
        sb.append(", TTL: ").append(this.mTtl);
        sb.append(", Location Policy: ").append(this.mLocationPolicy);
        sb.append(", WriteType: ").append(this.mWriteType.toString());
        sb.append(")");
        return sb.toString();
    }

    public CreateFileTOptions toThrift() {
        CreateFileTOptions options = new CreateFileTOptions();
        options.setBlockSizeBytes(this.mBlockSizeBytes);
        options.setPersisted(this.mWriteType.getUnderStorageType().isSyncPersist());
        options.setRecursive(this.mRecursive);
        options.setTtl(this.mTtl);
        return options;
    }
}

