/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.client.AlluxioStorageType;
import alluxio.client.ClientContext;
import alluxio.client.ReadType;
import alluxio.client.file.policy.FileWriteLocationPolicy;
import alluxio.util.CommonUtils;
import com.google.common.base.Throwables;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class InStreamOptions {
    private FileWriteLocationPolicy mLocationPolicy;
    private ReadType mReadType = (ReadType)ClientContext.getConf().getEnum("alluxio.user.file.readtype.default", ReadType.class);

    public static InStreamOptions defaults() {
        return new InStreamOptions();
    }

    private InStreamOptions() {
        try {
            this.mLocationPolicy = (FileWriteLocationPolicy)CommonUtils.createNewClassInstance((Class)ClientContext.getConf().getClass("alluxio.user.file.write.location.policy.class"), (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public FileWriteLocationPolicy getLocationPolicy() {
        return this.mLocationPolicy;
    }

    public AlluxioStorageType getAlluxioStorageType() {
        return this.mReadType.getAlluxioStorageType();
    }

    public InStreamOptions setLocationPolicy(FileWriteLocationPolicy policy) {
        this.mLocationPolicy = policy;
        return this;
    }

    public InStreamOptions setReadType(ReadType readType) {
        this.mReadType = readType;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("InStreamOptions(");
        sb.append(super.toString()).append(", ReadType: ").append(this.mReadType.toString());
        sb.append(", LocationPolicy: ").append(this.mLocationPolicy.toString());
        sb.append(")");
        return sb.toString();
    }
}

