/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.Configuration;
import alluxio.client.AlluxioStorageType;
import alluxio.client.ClientContext;
import alluxio.client.UnderStorageType;
import alluxio.client.WriteType;
import alluxio.client.file.policy.FileWriteLocationPolicy;
import alluxio.util.CommonUtils;
import com.google.common.base.Throwables;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class OutStreamOptions {
    private long mBlockSizeBytes;
    private long mTtl;
    private FileWriteLocationPolicy mLocationPolicy;
    private WriteType mWriteType;

    public static OutStreamOptions defaults() {
        return new OutStreamOptions();
    }

    private OutStreamOptions() {
        Configuration conf = ClientContext.getConf();
        this.mBlockSizeBytes = conf.getBytes("alluxio.user.block.size.bytes.default");
        this.mTtl = -1L;
        try {
            this.mLocationPolicy = (FileWriteLocationPolicy)CommonUtils.createNewClassInstance((Class)ClientContext.getConf().getClass("alluxio.user.file.write.location.policy.class"), (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.mWriteType = (WriteType)conf.getEnum("alluxio.user.file.writetype.default", WriteType.class);
    }

    public long getBlockSizeBytes() {
        return this.mBlockSizeBytes;
    }

    public FileWriteLocationPolicy getLocationPolicy() {
        return this.mLocationPolicy;
    }

    public AlluxioStorageType getAlluxioStorageType() {
        return this.mWriteType.getAlluxioStorageType();
    }

    public long getTtl() {
        return this.mTtl;
    }

    public UnderStorageType getUnderStorageType() {
        return this.mWriteType.getUnderStorageType();
    }

    public OutStreamOptions setBlockSizeBytes(long blockSizeBytes) {
        this.mBlockSizeBytes = blockSizeBytes;
        return this;
    }

    public OutStreamOptions setTtl(long ttl) {
        this.mTtl = ttl;
        return this;
    }

    public OutStreamOptions setLocationPolicy(FileWriteLocationPolicy locationPolicy) {
        this.mLocationPolicy = locationPolicy;
        return this;
    }

    public OutStreamOptions setWriteType(WriteType writeType) {
        this.mWriteType = writeType;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OutStreamOptions(");
        sb.append(super.toString()).append(", BlockSizeBytes: ").append(this.mBlockSizeBytes);
        sb.append(", TTL: ").append(this.mTtl);
        sb.append(", LocationPolicy: ").append(this.mLocationPolicy.toString());
        sb.append(", WriteType: ").append(this.mWriteType.toString());
        sb.append(")");
        return sb.toString();
    }
}

