/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.thrift.SetAttributeTOptions;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class SetAttributeOptions {
    private Boolean mPinned = null;
    private Long mTtl = null;
    private Boolean mPersisted = null;
    private String mOwner = null;
    private String mGroup = null;
    private Short mPermission = -1;
    private boolean mRecursive = false;

    public static SetAttributeOptions defaults() {
        return new SetAttributeOptions();
    }

    private SetAttributeOptions() {
    }

    public boolean hasPinned() {
        return this.mPinned != null;
    }

    public boolean getPinned() {
        Preconditions.checkState((boolean)this.hasPinned(), (Object)"The pinned flag must be set");
        return this.mPinned;
    }

    public boolean hasTtl() {
        return this.mTtl != null;
    }

    public long getTtl() {
        Preconditions.checkState((boolean)this.hasTtl(), (Object)"The TTL value must be set");
        return this.mTtl;
    }

    public boolean hasPersisted() {
        return this.mPersisted != null;
    }

    public boolean getPersisted() {
        Preconditions.checkState((boolean)this.hasPersisted(), (Object)"The persisted value must be set");
        return this.mPersisted;
    }

    public boolean hasOwner() {
        return this.mOwner != null;
    }

    public String getOwner() {
        Preconditions.checkState((boolean)this.hasOwner(), (Object)"The owner must be set");
        return this.mOwner;
    }

    public boolean hasGroup() {
        return this.mGroup != null;
    }

    public String getGroup() {
        Preconditions.checkState((boolean)this.hasGroup(), (Object)"The group must be set");
        return this.mGroup;
    }

    public boolean hasPermission() {
        return this.mPermission != -1;
    }

    public short getPermission() {
        Preconditions.checkState((boolean)this.hasPermission(), (Object)"The permission must be set");
        return this.mPermission;
    }

    public boolean isRecursive() {
        return this.mRecursive;
    }

    public SetAttributeOptions setPinned(boolean pinned) {
        this.mPinned = pinned;
        return this;
    }

    public SetAttributeOptions setTtl(long ttl) {
        this.mTtl = ttl;
        return this;
    }

    public SetAttributeOptions setPersisted(boolean persisted) {
        this.mPersisted = persisted;
        return this;
    }

    public SetAttributeOptions setOwner(String owner) {
        this.mOwner = owner;
        return this;
    }

    public SetAttributeOptions setGroup(String group) {
        this.mGroup = group;
        return this;
    }

    public SetAttributeOptions setPermission(short permission) {
        this.mPermission = permission;
        return this;
    }

    public SetAttributeOptions setRecursive(boolean recursive) {
        this.mRecursive = recursive;
        return this;
    }

    public SetAttributeTOptions toThrift() {
        SetAttributeTOptions options = new SetAttributeTOptions();
        if (this.mPinned != null) {
            options.setPinned(this.mPinned.booleanValue());
        }
        if (this.mTtl != null) {
            options.setTtl(this.mTtl.longValue());
        }
        if (this.mPersisted != null) {
            options.setPersisted(this.mPersisted.booleanValue());
        }
        if (this.mOwner != null) {
            options.setOwner(this.mOwner);
        }
        if (this.mGroup != null) {
            options.setGroup(this.mGroup);
        }
        if (this.mPermission != -1) {
            options.setPermission(this.mPermission.shortValue());
        }
        options.setRecursive(this.mRecursive);
        return options;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SetStateOptions(");
        sb.append(super.toString()).append(", Pinned: ").append(this.mPinned).append(", TTL: ").append(this.mTtl).append(", Persisted: ").append(this.mPersisted).append(", Owner: ").append(this.mOwner).append(", Group: ").append(this.mGroup).append(", Permission: ").append(this.mPermission).append(", Recursive: ").append(this.mRecursive);
        sb.append(")");
        return sb.toString();
    }
}

