/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.policy;

import alluxio.Configuration;
import alluxio.client.ClientContext;
import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.policy.FileWriteLocationPolicy;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerNetAddress;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LocalFirstPolicy
implements FileWriteLocationPolicy {
    private String mLocalHostName = NetworkAddressUtils.getLocalHostName((Configuration)ClientContext.getConf());

    @Override
    public WorkerNetAddress getWorkerForNextBlock(List<BlockWorkerInfo> workerInfoList, long blockSizeBytes) {
        for (BlockWorkerInfo workerInfo : workerInfoList) {
            if (!workerInfo.getNetAddress().getHost().equals(this.mLocalHostName) || workerInfo.getCapacityBytes() < blockSizeBytes) continue;
            return workerInfo.getNetAddress();
        }
        Collections.shuffle(workerInfoList);
        for (BlockWorkerInfo workerInfo : workerInfoList) {
            if (workerInfo.getCapacityBytes() < blockSizeBytes) continue;
            return workerInfo.getNetAddress();
        }
        return null;
    }
}

