/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.policy;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.policy.FileWriteLocationPolicy;
import alluxio.wire.WorkerNetAddress;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MostAvailableFirstPolicy
implements FileWriteLocationPolicy {
    @Override
    public WorkerNetAddress getWorkerForNextBlock(List<BlockWorkerInfo> workerInfoList, long blockSizeBytes) {
        ArrayList inputList = Lists.newArrayList(workerInfoList);
        long mostAvailableBytes = -1L;
        WorkerNetAddress result = null;
        for (BlockWorkerInfo workerInfo : inputList) {
            if (workerInfo.getCapacityBytes() - workerInfo.getUsedBytes() <= mostAvailableBytes) continue;
            mostAvailableBytes = workerInfo.getCapacityBytes() - workerInfo.getUsedBytes();
            result = workerInfo.getNetAddress();
        }
        return result;
    }
}

