/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.policy;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.policy.FileWriteLocationPolicy;
import alluxio.wire.WorkerNetAddress;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class RoundRobinPolicy
implements FileWriteLocationPolicy {
    private List<BlockWorkerInfo> mWorkerInfoList;
    private int mIndex;
    private boolean mInitialized = false;

    @Override
    public WorkerNetAddress getWorkerForNextBlock(List<BlockWorkerInfo> workerInfoList, long blockSizeBytes) {
        if (!this.mInitialized) {
            this.mWorkerInfoList = workerInfoList;
            Collections.shuffle(this.mWorkerInfoList);
            this.mIndex = 0;
            this.mInitialized = true;
        }
        for (int i = 0; i < this.mWorkerInfoList.size(); ++i) {
            WorkerNetAddress candidate = this.mWorkerInfoList.get(this.mIndex).getNetAddress();
            BlockWorkerInfo workerInfo = this.findBlockWorkerInfo(workerInfoList, candidate);
            this.mIndex = (this.mIndex + 1) % this.mWorkerInfoList.size();
            if (workerInfo == null || workerInfo.getCapacityBytes() < blockSizeBytes) continue;
            return candidate;
        }
        return null;
    }

    private BlockWorkerInfo findBlockWorkerInfo(List<BlockWorkerInfo> workerInfoList, WorkerNetAddress address) {
        for (BlockWorkerInfo info : workerInfoList) {
            if (!info.getNetAddress().equals((Object)address)) continue;
            return info;
        }
        return null;
    }
}

